package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Expevent;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExpeventDAO implements clinical.server.dao.ExpeventDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExpeventDAO() {}

	public void insert(Connection con, Expevent bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_EXPEVENT ");
			buf
					.append(" (EXPMANIPULATIONID,TABLEID,OWNER,MODTIME,MODUSER,EXTENSIONNAME,CONDITION,EVENTTYPE,ONSETTIME,DURATION,TEXTVALUE,DESCRIPTION,ONTOLOGYSOURCE,CONCEPTID,ISCOMPOSITE,UNIQUEID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 16; ++i) {
				buf.append('?');
				if (i < 15)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getExpmanipulationid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6, (String) bean.getExtensionname(), Types.VARCHAR);
			ps.setObject(7, (String) bean.getCondition(), Types.VARCHAR);
			ps.setObject(8, (String) bean.getEventtype(), Types.VARCHAR);
			ps.setObject(9, (Float) bean.getOnsettime(), Types.FLOAT);
			ps.setObject(10, (Float) bean.getDuration(), Types.FLOAT);
			ps.setObject(11, (String) bean.getTextvalue(), Types.VARCHAR);
			ps.setObject(12, OracleUtils.getCLOB(con, bean.getDescription()),
					Types.CLOB);
			ps.setObject(13, (String) bean.getOntologysource(), Types.VARCHAR);
			ps.setObject(14, (String) bean.getConceptid(), Types.VARCHAR);
			ps.setObject(15, boolean2Number((Boolean) bean.getIscomposite()),
					Types.NUMERIC);
			ps.setObject(16, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Expevent bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("EXPMANIPULATIONID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("EXTENSIONNAME");
		buf.append(',');
		buf.append("CONDITION");
		buf.append(',');
		buf.append("EVENTTYPE");
		buf.append(',');
		buf.append("ONSETTIME");
		buf.append(',');
		buf.append("DURATION");
		buf.append(',');
		buf.append("TEXTVALUE");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(',');
		buf.append("ONTOLOGYSOURCE");
		buf.append(',');
		buf.append("CONCEPTID");
		buf.append(',');
		buf.append("ISCOMPOSITE");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Expevent bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getExpmanipulationid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXPMANIPULATIONID=?");
			qi.values.add(bean.getExpmanipulationid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getExtensionname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXTENSIONNAME=?");
			qi.values.add(bean.getExtensionname());
			valueSet = true;
		}
		if (bean.getCondition() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONDITION=?");
			qi.values.add(bean.getCondition());
			valueSet = true;
		}
		if (bean.getEventtype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EVENTTYPE=?");
			qi.values.add(bean.getEventtype());
			valueSet = true;
		}
		if (bean.getOnsettime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ONSETTIME=?");
			qi.values.add(bean.getOnsettime());
			valueSet = true;
		}
		if (bean.getDuration() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DURATION=?");
			qi.values.add(bean.getDuration());
			valueSet = true;
		}
		if (bean.getTextvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TEXTVALUE=?");
			qi.values.add(bean.getTextvalue());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getOntologysource() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ONTOLOGYSOURCE=?");
			qi.values.add(bean.getOntologysource());
			valueSet = true;
		}
		if (bean.getConceptid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONCEPTID=?");
			qi.values.add(bean.getConceptid());
			valueSet = true;
		}
		if (bean.getIscomposite() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISCOMPOSITE=?");
			qi.values.add(boolean2Number((Boolean) bean.getIscomposite()));
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Expevent bean, Expevent criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_EXPEVENT SET ");

		if (bean.getExpmanipulationid() != null
				|| bean.isNull("expmanipulationid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXPMANIPULATIONID=? ");
			uqi.setValues.add(bean.getExpmanipulationid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("expmanipulationid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getExtensionname() != null || bean.isNull("extensionname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXTENSIONNAME=? ");
			uqi.setValues.add(bean.getExtensionname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("extensionname"), uqi);
			valueSet = true;
		}
		if (bean.getCondition() != null || bean.isNull("condition")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONDITION=? ");
			uqi.setValues.add(bean.getCondition());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("condition"), uqi);
			valueSet = true;
		}
		if (bean.getEventtype() != null || bean.isNull("eventtype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EVENTTYPE=? ");
			uqi.setValues.add(bean.getEventtype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("eventtype"), uqi);
			valueSet = true;
		}
		if (bean.getOnsettime() != null || bean.isNull("onsettime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ONSETTIME=? ");
			uqi.setValues.add(bean.getOnsettime());
			uqi.sqlTypes.add(new Integer(Types.FLOAT));
			prepareNullSetListValue(bean.isNull("onsettime"), uqi);
			valueSet = true;
		}
		if (bean.getDuration() != null || bean.isNull("duration")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DURATION=? ");
			uqi.setValues.add(bean.getDuration());
			uqi.sqlTypes.add(new Integer(Types.FLOAT));
			prepareNullSetListValue(bean.isNull("duration"), uqi);
			valueSet = true;
		}
		if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TEXTVALUE=? ");
			uqi.setValues.add(bean.getTextvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textvalue"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getOntologysource() != null || bean.isNull("ontologysource")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ONTOLOGYSOURCE=? ");
			uqi.setValues.add(bean.getOntologysource());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("ontologysource"), uqi);
			valueSet = true;
		}
		if (bean.getConceptid() != null || bean.isNull("conceptid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONCEPTID=? ");
			uqi.setValues.add(bean.getConceptid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conceptid"), uqi);
			valueSet = true;
		}
		if (bean.getIscomposite() != null || bean.isNull("iscomposite")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISCOMPOSITE=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIscomposite()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("iscomposite"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Expevent createObject(ResultSet rs) throws SQLException {
		Expevent obj = new Expevent();
		obj.setExpmanipulationid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setExtensionname((String) rs.getObject(6));
		obj.setCondition((String) rs.getObject(7));
		obj.setEventtype((String) rs.getObject(8));
		obj.setOnsettime((Float) rs.getObject(9));
		obj.setDuration((Float) rs.getObject(10));
		obj.setTextvalue((String) rs.getObject(11));
		obj.setDescription(OracleUtils.readCLOB((oracle.sql.CLOB) rs
				.getObject(12)));
		obj.setOntologysource((String) rs.getObject(13));
		obj.setConceptid((String) rs.getObject(14));
		obj.setIscomposite(convert2Boolean(rs.getObject(15)));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(16));
		return obj;
	}

	public List<Expevent> find(Connection con, Expevent criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Expevent> results = new LinkedList<Expevent>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_EXPEVENT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Expevent item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Expevent bean, Expevent criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Expevent criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_EXPEVENT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
