package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Expsegment;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExpsegmentDAO implements clinical.server.dao.ExpsegmentDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExpsegmentDAO() {}

	public void insert(Connection con, Expsegment bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_EXPSEGMENT ");
			buf
					.append(" (SEGMENTID,COMPONENTID,NC_EXPERIMENT_UNIQUEID,SUBJECTID,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,TIME_STAMP,DESCRIPTION,PROTOCOLVERSION,PROTOCOLID,STUDYID,NAME,ISTIMEINTERVAL,TIMEINTERVAL,ISBAD) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 18; ++i) {
				buf.append('?');
				if (i < 17)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getSegmentid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getComponentid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getNcExperimentUniqueid(),
					Types.NUMERIC);
			ps.setObject(4, (String) bean.getSubjectid(), Types.VARCHAR);
			ps.setObject(5, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(7, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(8, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(9, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(10, (java.sql.Timestamp) bean.getTimeStamp(),
					Types.TIMESTAMP);
			ps.setObject(11, OracleUtils.getCLOB(con, bean.getDescription()),
					Types.CLOB);
			ps.setObject(12, (java.math.BigDecimal) bean.getProtocolversion(),
					Types.NUMERIC);
			ps.setObject(13, (String) bean.getProtocolid(), Types.VARCHAR);
			ps.setObject(14, (java.math.BigDecimal) bean.getStudyid(),
					Types.NUMERIC);
			ps.setObject(15, (String) bean.getName(), Types.VARCHAR);
			ps.setObject(16, boolean2Number((Boolean) bean.getIstimeinterval()),
					Types.NUMERIC);
			ps.setObject(17, (Float) bean.getTimeinterval(), Types.FLOAT);
			ps.setObject(18, boolean2Number((Boolean) bean.getIsbad()),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Expsegment bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("SEGMENTID");
		buf.append(',');
		buf.append("COMPONENTID");
		buf.append(',');
		buf.append("NC_EXPERIMENT_UNIQUEID");
		buf.append(',');
		buf.append("SUBJECTID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("TIME_STAMP");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(',');
		buf.append("PROTOCOLVERSION");
		buf.append(',');
		buf.append("PROTOCOLID");
		buf.append(',');
		buf.append("STUDYID");
		buf.append(',');
		buf.append("NAME");
		buf.append(',');
		buf.append("ISTIMEINTERVAL");
		buf.append(',');
		buf.append("TIMEINTERVAL");
		buf.append(',');
		buf.append("ISBAD");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Expsegment bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getSegmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SEGMENTID=?");
			qi.values.add(bean.getSegmentid());
			valueSet = true;
		}
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMPONENTID=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getNcExperimentUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_EXPERIMENT_UNIQUEID=?");
			qi.values.add(bean.getNcExperimentUniqueid());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SUBJECTID=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getTimeStamp() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TIME_STAMP=?");
			qi.values.add(bean.getTimeStamp());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getProtocolversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PROTOCOLVERSION=?");
			qi.values.add(bean.getProtocolversion());
			valueSet = true;
		}
		if (bean.getProtocolid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PROTOCOLID=?");
			qi.values.add(bean.getProtocolid());
			valueSet = true;
		}
		if (bean.getStudyid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("STUDYID=?");
			qi.values.add(bean.getStudyid());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NAME=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getIstimeinterval() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISTIMEINTERVAL=?");
			qi.values.add(boolean2Number((Boolean) bean.getIstimeinterval()));
			valueSet = true;
		}
		if (bean.getTimeinterval() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TIMEINTERVAL=?");
			qi.values.add(bean.getTimeinterval());
			valueSet = true;
		}
		if (bean.getIsbad() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISBAD=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsbad()));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Expsegment bean,
			Expsegment criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_EXPSEGMENT SET ");

		if (bean.getSegmentid() != null || bean.isNull("segmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SEGMENTID=? ");
			uqi.setValues.add(bean.getSegmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("segmentid"), uqi);
			valueSet = true;
		}
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMPONENTID=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getNcExperimentUniqueid() != null
				|| bean.isNull("ncExperimentUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_EXPERIMENT_UNIQUEID=? ");
			uqi.setValues.add(bean.getNcExperimentUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncExperimentUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SUBJECTID=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getTimeStamp() != null || bean.isNull("timeStamp")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TIME_STAMP=? ");
			uqi.setValues.add(bean.getTimeStamp());
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("timeStamp"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getProtocolversion() != null || bean.isNull("protocolversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PROTOCOLVERSION=? ");
			uqi.setValues.add(bean.getProtocolversion());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("protocolversion"), uqi);
			valueSet = true;
		}
		if (bean.getProtocolid() != null || bean.isNull("protocolid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PROTOCOLID=? ");
			uqi.setValues.add(bean.getProtocolid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("protocolid"), uqi);
			valueSet = true;
		}
		if (bean.getStudyid() != null || bean.isNull("studyid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("STUDYID=? ");
			uqi.setValues.add(bean.getStudyid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("studyid"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NAME=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getIstimeinterval() != null || bean.isNull("istimeinterval")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISTIMEINTERVAL=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIstimeinterval()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("istimeinterval"), uqi);
			valueSet = true;
		}
		if (bean.getTimeinterval() != null || bean.isNull("timeinterval")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TIMEINTERVAL=? ");
			uqi.setValues.add(bean.getTimeinterval());
			uqi.sqlTypes.add(new Integer(Types.FLOAT));
			prepareNullSetListValue(bean.isNull("timeinterval"), uqi);
			valueSet = true;
		}
		if (bean.getIsbad() != null || bean.isNull("isbad")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISBAD=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsbad()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isbad"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Expsegment createObject(ResultSet rs) throws SQLException {
		Expsegment obj = new Expsegment();
		obj.setSegmentid((java.math.BigDecimal) rs.getObject(1));
		obj.setComponentid((java.math.BigDecimal) rs.getObject(2));
		obj.setNcExperimentUniqueid((java.math.BigDecimal) rs.getObject(3));
		obj.setSubjectid((String) rs.getObject(4));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(5));
		obj.setTableid((java.math.BigDecimal) rs.getObject(6));
		obj.setOwner((java.math.BigDecimal) rs.getObject(7));
		if (rs.getTimestamp(8) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(8).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(9));
		obj.setTimeStamp(OracleUtils.getTimestamp(rs.getObject(10)));
		obj.setDescription(OracleUtils.readCLOB((oracle.sql.CLOB) rs
				.getObject(11)));
		obj.setProtocolversion((java.math.BigDecimal) rs.getObject(12));
		obj.setProtocolid((String) rs.getObject(13));
		obj.setStudyid((java.math.BigDecimal) rs.getObject(14));
		obj.setName((String) rs.getObject(15));
		obj.setIstimeinterval(convert2Boolean(rs.getObject(16)));
		obj.setTimeinterval((Float) rs.getObject(17));
		obj.setIsbad(convert2Boolean(rs.getObject(18)));
		return obj;
	}

	public List<Expsegment> find(Connection con, Expsegment criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Expsegment> results = new LinkedList<Expsegment>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_EXPSEGMENT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Expsegment item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Expsegment bean, Expsegment criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Expsegment criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_EXPSEGMENT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
