package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Protocol;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ProtocolDAO implements clinical.server.dao.ProtocolDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ProtocolDAO() {}

	public void insert(Connection con, Protocol bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_PROTOCOL ");
			buf
					.append(" (PROTOCOLVERSION,PROTOCOLID,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,NAME,DESCRIPTION) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 9; ++i) {
				buf.append('?');
				if (i < 8)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getProtocolversion(),
					Types.NUMERIC);
			ps.setObject(2, (String) bean.getProtocolid(), Types.VARCHAR);
			ps.setObject(3, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(4, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(5, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(6, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(7, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(8, (String) bean.getName(), Types.VARCHAR);
			ps.setObject(9, OracleUtils.getCLOB(con, bean.getDescription()),
					Types.CLOB);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Protocol bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("PROTOCOLVERSION");
		buf.append(',');
		buf.append("PROTOCOLID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("NAME");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Protocol bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getProtocolversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PROTOCOLVERSION=?");
			qi.values.add(bean.getProtocolversion());
			valueSet = true;
		}
		if (bean.getProtocolid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PROTOCOLID=?");
			qi.values.add(bean.getProtocolid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NAME=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Protocol bean, Protocol criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_PROTOCOL SET ");

		if (bean.getProtocolversion() != null || bean.isNull("protocolversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PROTOCOLVERSION=? ");
			uqi.setValues.add(bean.getProtocolversion());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("protocolversion"), uqi);
			valueSet = true;
		}
		if (bean.getProtocolid() != null || bean.isNull("protocolid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PROTOCOLID=? ");
			uqi.setValues.add(bean.getProtocolid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("protocolid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NAME=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Protocol createObject(ResultSet rs) throws SQLException {
		Protocol obj = new Protocol();
		obj.setProtocolversion((java.math.BigDecimal) rs.getObject(1));
		obj.setProtocolid((String) rs.getObject(2));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(3));
		obj.setTableid((java.math.BigDecimal) rs.getObject(4));
		obj.setOwner((java.math.BigDecimal) rs.getObject(5));
		if (rs.getTimestamp(6) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(6).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(7));
		obj.setName((String) rs.getObject(8));
		obj.setDescription(OracleUtils
				.readCLOB((oracle.sql.CLOB) rs.getObject(9)));
		return obj;
	}

	public List<Protocol> find(Connection con, Protocol criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Protocol> results = new LinkedList<Protocol>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_PROTOCOL ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Protocol item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Protocol bean, Protocol criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Protocol criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_PROTOCOL ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
