package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Rangevalidator;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class RangevalidatorDAO implements clinical.server.dao.RangevalidatorDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public RangevalidatorDAO() {}

	public void insert(Connection con, Rangevalidator bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_RANGEVALIDATOR ");
			buf
					.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,LOWLIMIT,UPPERLIMIT,INCLOWLIMIT,INCUPPERLIMIT) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 9; ++i) {
				buf.append('?');
				if (i < 8)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getLowlimit(),
					Types.NUMERIC);
			ps.setObject(7, (java.math.BigDecimal) bean.getUpperlimit(),
					Types.NUMERIC);
			ps.setObject(8, boolean2YN((Boolean) bean.getInclowlimit()),
					Types.CHAR);
			ps.setObject(9, boolean2YN((Boolean) bean.getIncupperlimit()),
					Types.CHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Rangevalidator bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("LOWLIMIT");
		buf.append(',');
		buf.append("UPPERLIMIT");
		buf.append(',');
		buf.append("INCLOWLIMIT");
		buf.append(',');
		buf.append("INCUPPERLIMIT");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Rangevalidator bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getLowlimit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("LOWLIMIT=?");
			qi.values.add(bean.getLowlimit());
			valueSet = true;
		}
		if (bean.getUpperlimit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UPPERLIMIT=?");
			qi.values.add(bean.getUpperlimit());
			valueSet = true;
		}
		if (bean.getInclowlimit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("INCLOWLIMIT=?");
			qi.values.add(boolean2YN((Boolean) bean.getInclowlimit()));
			valueSet = true;
		}
		if (bean.getIncupperlimit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("INCUPPERLIMIT=?");
			qi.values.add(boolean2YN((Boolean) bean.getIncupperlimit()));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Rangevalidator bean,
			Rangevalidator criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_RANGEVALIDATOR SET ");

		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getLowlimit() != null || bean.isNull("lowlimit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("LOWLIMIT=? ");
			uqi.setValues.add(bean.getLowlimit());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("lowlimit"), uqi);
			valueSet = true;
		}
		if (bean.getUpperlimit() != null || bean.isNull("upperlimit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UPPERLIMIT=? ");
			uqi.setValues.add(bean.getUpperlimit());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("upperlimit"), uqi);
			valueSet = true;
		}
		if (bean.getInclowlimit() != null || bean.isNull("inclowlimit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("INCLOWLIMIT=? ");
			uqi.setValues.add(boolean2YN((Boolean) bean.getInclowlimit()));
			uqi.sqlTypes.add(new Integer(Types.CHAR));
			prepareNullSetListValue(bean.isNull("inclowlimit"), uqi);
			valueSet = true;
		}
		if (bean.getIncupperlimit() != null || bean.isNull("incupperlimit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("INCUPPERLIMIT=? ");
			uqi.setValues.add(boolean2YN((Boolean) bean.getIncupperlimit()));
			uqi.sqlTypes.add(new Integer(Types.CHAR));
			prepareNullSetListValue(bean.isNull("incupperlimit"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Rangevalidator createObject(ResultSet rs) throws SQLException {
		Rangevalidator obj = new Rangevalidator();
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setLowlimit((java.math.BigDecimal) rs.getObject(6));
		obj.setUpperlimit((java.math.BigDecimal) rs.getObject(7));
		obj
				.setInclowlimit(((String) rs.getObject(8)).equalsIgnoreCase("y") ? new Boolean(
						true)
						: new Boolean(false));
		obj
				.setIncupperlimit(((String) rs.getObject(9)).equalsIgnoreCase("y") ? new Boolean(
						true)
						: new Boolean(false));
		return obj;
	}

	public List<Rangevalidator> find(Connection con, Rangevalidator criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Rangevalidator> results = new LinkedList<Rangevalidator>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_RANGEVALIDATOR ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Rangevalidator item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Rangevalidator bean,
			Rangevalidator criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Rangevalidator criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_RANGEVALIDATOR ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
