package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ScoreSynonymExperiment;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ScoreSynonymExperimentDAO implements
		clinical.server.dao.ScoreSynonymExperimentDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ScoreSynonymExperimentDAO() {
	}

	public void insert(Connection con, ScoreSynonymExperiment bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_score_synonym_experiment VALUES ");
			buf.append('(');
			for (int i = 0; i < 2; ++i) {
				buf.append('?');
				if (i < 1)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getScoreSynonymId(), Types.NUMERIC);

			ps.setObject(2, bean.getExperimentId(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(ScoreSynonymExperiment bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("score_synonym_id");
		buf.append(',');
		buf.append("experiment_id");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ScoreSynonymExperiment bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getScoreSynonymId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("score_synonym_id=?");
			qi.values.add(bean.getScoreSynonymId());
			valueSet = true;
		}
		if (bean.getExperimentId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("experiment_id=?");
			qi.values.add(bean.getExperimentId());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ScoreSynonymExperiment bean,
			ScoreSynonymExperiment criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_score_synonym_experiment SET ");
		if (bean.getScoreSynonymId() != null || bean.isNull("scoreSynonymId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("score_synonym_id=? ");
			uqi.setValues.add(bean.getScoreSynonymId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("scoreSynonymId"), uqi);
			valueSet = true;
		}
		if (bean.getExperimentId() != null || bean.isNull("experimentId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("experiment_id=? ");
			uqi.setValues.add(bean.getExperimentId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("experimentId"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public ScoreSynonymExperiment createObject(ResultSet rs)
			throws SQLException {
		ScoreSynonymExperiment obj = new ScoreSynonymExperiment();
		obj.setScoreSynonymId((rs.getObject(1) != null) ? new java.math.BigDecimal(
				rs.getObject(1).toString()) : null);
		obj.setExperimentId((rs.getObject(2) != null) ? new java.math.BigDecimal(
				rs.getObject(2).toString()) : null);
		return obj;
	}

	public List<ScoreSynonymExperiment> find(Connection con,
			ScoreSynonymExperiment criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ScoreSynonymExperiment> results = new LinkedList<ScoreSynonymExperiment>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_score_synonym_experiment ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ScoreSynonymExperiment item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ScoreSynonymExperiment bean,
			ScoreSynonymExperiment criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ScoreSynonymExperiment criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_score_synonym_experiment ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
