package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Tupleaccess;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TupleaccessDAO implements clinical.server.dao.TupleaccessDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TupleaccessDAO() {}

	public void insert(Connection con, Tupleaccess bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_TUPLEACCESS ");
			buf
					.append(" (TABLEID,TUPLEID,GRANTOR,GRANTEE,MODTIME,CAN_READ,CAN_WRITE,CAN_DELETE,CAN_ADMIN,MODUSER,OWNER) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 11; ++i) {
				buf.append('?');
				if (i < 10)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTupleid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getGrantor(),
					Types.NUMERIC);
			ps.setObject(4, (java.math.BigDecimal) bean.getGrantee(),
					Types.NUMERIC);
			ps.setTimestamp(5, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(6, boolean2Number((Boolean) bean.getCanRead()),
					Types.NUMERIC);
			ps.setObject(7, boolean2Number((Boolean) bean.getCanWrite()),
					Types.NUMERIC);
			ps.setObject(8, boolean2Number((Boolean) bean.getCanDelete()),
					Types.NUMERIC);
			ps.setObject(9, boolean2Number((Boolean) bean.getCanAdmin()),
					Types.NUMERIC);
			ps.setObject(10, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps
					.setObject(11, (java.math.BigDecimal) bean.getOwner(),
							Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Tupleaccess bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("TABLEID");
		buf.append(',');
		buf.append("TUPLEID");
		buf.append(',');
		buf.append("GRANTOR");
		buf.append(',');
		buf.append("GRANTEE");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("CAN_READ");
		buf.append(',');
		buf.append("CAN_WRITE");
		buf.append(',');
		buf.append("CAN_DELETE");
		buf.append(',');
		buf.append("CAN_ADMIN");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("OWNER");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Tupleaccess bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getTupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TUPLEID=?");
			qi.values.add(bean.getTupleid());
			valueSet = true;
		}
		if (bean.getGrantor() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("GRANTOR=?");
			qi.values.add(bean.getGrantor());
			valueSet = true;
		}
		if (bean.getGrantee() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("GRANTEE=?");
			qi.values.add(bean.getGrantee());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getCanRead() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_READ=?");
			qi.values.add(boolean2Number((Boolean) bean.getCanRead()));
			valueSet = true;
		}
		if (bean.getCanWrite() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_WRITE=?");
			qi.values.add(boolean2Number((Boolean) bean.getCanWrite()));
			valueSet = true;
		}
		if (bean.getCanDelete() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_DELETE=?");
			qi.values.add(boolean2Number((Boolean) bean.getCanDelete()));
			valueSet = true;
		}
		if (bean.getCanAdmin() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CAN_ADMIN=?");
			qi.values.add(boolean2Number((Boolean) bean.getCanAdmin()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Tupleaccess bean,
			Tupleaccess criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_TUPLEACCESS SET ");

		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getTupleid() != null || bean.isNull("tupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TUPLEID=? ");
			uqi.setValues.add(bean.getTupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tupleid"), uqi);
			valueSet = true;
		}
		if (bean.getGrantor() != null || bean.isNull("grantor")) {
			if (valueSet)
				buf.append(", ");
			buf.append("GRANTOR=? ");
			uqi.setValues.add(bean.getGrantor());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("grantor"), uqi);
			valueSet = true;
		}
		if (bean.getGrantee() != null || bean.isNull("grantee")) {
			if (valueSet)
				buf.append(", ");
			buf.append("GRANTEE=? ");
			uqi.setValues.add(bean.getGrantee());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("grantee"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getCanRead() != null || bean.isNull("canRead")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_READ=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getCanRead()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("canRead"), uqi);
			valueSet = true;
		}
		if (bean.getCanWrite() != null || bean.isNull("canWrite")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_WRITE=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getCanWrite()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("canWrite"), uqi);
			valueSet = true;
		}
		if (bean.getCanDelete() != null || bean.isNull("canDelete")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_DELETE=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getCanDelete()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("canDelete"), uqi);
			valueSet = true;
		}
		if (bean.getCanAdmin() != null || bean.isNull("canAdmin")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CAN_ADMIN=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getCanAdmin()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("canAdmin"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Tupleaccess createObject(ResultSet rs) throws SQLException {
		Tupleaccess obj = new Tupleaccess();
		obj.setTableid((java.math.BigDecimal) rs.getObject(1));
		obj.setTupleid((java.math.BigDecimal) rs.getObject(2));
		obj.setGrantor((java.math.BigDecimal) rs.getObject(3));
		obj.setGrantee((java.math.BigDecimal) rs.getObject(4));
		if (rs.getTimestamp(5) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(5).getTime()));
		}
		obj.setCanRead(convert2Boolean(rs.getObject(6)));
		obj.setCanWrite(convert2Boolean(rs.getObject(7)));
		obj.setCanDelete(convert2Boolean(rs.getObject(8)));
		obj.setCanAdmin(convert2Boolean(rs.getObject(9)));
		obj.setModuser((java.math.BigDecimal) rs.getObject(10));
		obj.setOwner((java.math.BigDecimal) rs.getObject(11));
		return obj;
	}

	public List<Tupleaccess> find(Connection con, Tupleaccess criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Tupleaccess> results = new LinkedList<Tupleaccess>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_TUPLEACCESS ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Tupleaccess item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Tupleaccess bean, Tupleaccess criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Tupleaccess criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_TUPLEACCESS ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
