package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Assessmentscorecode;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AssessmentscorecodeDAO implements
		clinical.server.dao.AssessmentscorecodeDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AssessmentscorecodeDAO() {
	}

	public void insert(Connection con, Assessmentscorecode bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_assessmentscorecode VALUES ");
			buf.append('(');
			for (int i = 0; i < 14; ++i) {
				buf.append('?');
				if (i < 13)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getAssessmentid(), Types.NUMERIC);

			ps.setObject(2, bean.getScorename(), Types.VARCHAR);

			ps.setObject(3, bean.getScorecode(), Types.VARCHAR);

			ps.setObject(4, bean.getScorecodelabel(), Types.VARCHAR);

			ps.setObject(5, bean.getTableid(), Types.NUMERIC);

			ps.setObject(6, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(7, bean.getOwner(), Types.NUMERIC);

			ps.setObject(8,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(9, bean.getModuser(), Types.NUMERIC);

			ps.setObject(10, bean.getScorecodevalue(), Types.VARCHAR);

			ps.setObject(11, bean.getScorecodetype(), Types.VARCHAR);

			ps.setObject(12, bean.getDescription(), Types.VARCHAR);

			ps.setObject(13, bean.getOntologysource(), Types.VARCHAR);

			ps.setObject(14, bean.getConceptid(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Assessmentscorecode bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("assessmentid");
		buf.append(',');
		buf.append("scorename");
		buf.append(',');
		buf.append("scorecode");
		buf.append(',');
		buf.append("scorecodelabel");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("scorecodevalue");
		buf.append(',');
		buf.append("scorecodetype");
		buf.append(',');
		buf.append("description");
		buf.append(',');
		buf.append("ontologysource");
		buf.append(',');
		buf.append("conceptid");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Assessmentscorecode bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getAssessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("assessmentid=?");
			qi.values.add(bean.getAssessmentid());
			valueSet = true;
		}
		if (bean.getScorename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scorename=?");
			qi.values.add(bean.getScorename());
			valueSet = true;
		}
		if (bean.getScorecode() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scorecode=?");
			qi.values.add(bean.getScorecode());
			valueSet = true;
		}
		if (bean.getScorecodelabel() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scorecodelabel=?");
			qi.values.add(bean.getScorecodelabel());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getScorecodevalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scorecodevalue=?");
			qi.values.add(bean.getScorecodevalue());
			valueSet = true;
		}
		if (bean.getScorecodetype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scorecodetype=?");
			qi.values.add(bean.getScorecodetype());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("description=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getOntologysource() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ontologysource=?");
			qi.values.add(bean.getOntologysource());
			valueSet = true;
		}
		if (bean.getConceptid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("conceptid=?");
			qi.values.add(bean.getConceptid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Assessmentscorecode bean,
			Assessmentscorecode criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_assessmentscorecode SET ");
		if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("assessmentid=? ");
			uqi.setValues.add(bean.getAssessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getScorename() != null || bean.isNull("scorename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scorename=? ");
			uqi.setValues.add(bean.getScorename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorename"), uqi);
			valueSet = true;
		}
		if (bean.getScorecode() != null || bean.isNull("scorecode")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scorecode=? ");
			uqi.setValues.add(bean.getScorecode());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecode"), uqi);
			valueSet = true;
		}
		if (bean.getScorecodelabel() != null || bean.isNull("scorecodelabel")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scorecodelabel=? ");
			uqi.setValues.add(bean.getScorecodelabel());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecodelabel"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getScorecodevalue() != null || bean.isNull("scorecodevalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scorecodevalue=? ");
			uqi.setValues.add(bean.getScorecodevalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecodevalue"), uqi);
			valueSet = true;
		}
		if (bean.getScorecodetype() != null || bean.isNull("scorecodetype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scorecodetype=? ");
			uqi.setValues.add(bean.getScorecodetype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecodetype"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("description=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getOntologysource() != null || bean.isNull("ontologysource")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ontologysource=? ");
			uqi.setValues.add(bean.getOntologysource());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("ontologysource"), uqi);
			valueSet = true;
		}
		if (bean.getConceptid() != null || bean.isNull("conceptid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("conceptid=? ");
			uqi.setValues.add(bean.getConceptid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conceptid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Assessmentscorecode createObject(ResultSet rs) throws SQLException {
		Assessmentscorecode obj = new Assessmentscorecode();
		obj
				.setAssessmentid((rs.getObject(1) != null) ? new java.math.BigDecimal(
						rs.getObject(1).toString())
						: null);
		obj.setScorename((String) rs.getObject(2));
		obj.setScorecode((String) rs.getObject(3));
		obj.setScorecodelabel((String) rs.getObject(4));
		obj.setTableid((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setUniqueid((rs.getObject(6) != null) ? new java.math.BigDecimal(rs
				.getObject(6).toString()) : null);
		obj.setOwner((rs.getObject(7) != null) ? new java.math.BigDecimal(rs
				.getObject(7).toString()) : null);
		obj.setModtime((rs.getObject(8) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(8)).getTime()) : null);
		obj.setModuser((rs.getObject(9) != null) ? new java.math.BigDecimal(rs
				.getObject(9).toString()) : null);
		obj.setScorecodevalue((String) rs.getObject(10));
		obj.setScorecodetype((String) rs.getObject(11));
		obj.setDescription((String) rs.getObject(12));
		obj.setOntologysource((String) rs.getObject(13));
		obj.setConceptid((String) rs.getObject(14));
		return obj;
	}

	public List<Assessmentscorecode> find(Connection con,
			Assessmentscorecode criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Assessmentscorecode> results = new LinkedList<Assessmentscorecode>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_assessmentscorecode ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Assessmentscorecode item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Assessmentscorecode bean,
			Assessmentscorecode criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Assessmentscorecode criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_assessmentscorecode ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
