package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.CanonicalScoreValue;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class CanonicalScoreValueDAO implements
		clinical.server.dao.CanonicalScoreValueDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public CanonicalScoreValueDAO() {
	}

	public void insert(Connection con, CanonicalScoreValue bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_canonical_score_value VALUES ");
			buf.append('(');
			for (int i = 0; i < 5; ++i) {
				buf.append('?');
				if (i < 4)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getAssessmentId(), Types.NUMERIC);

			ps.setObject(3, bean.getScoreId(), Types.NUMERIC);

			ps.setObject(4, bean.getScoreName(), Types.VARCHAR);

			ps.setObject(5, bean.getCanonicalValue(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(CanonicalScoreValue bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("assessment_id");
		buf.append(',');
		buf.append("score_id");
		buf.append(',');
		buf.append("score_name");
		buf.append(',');
		buf.append("canonical_value");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(CanonicalScoreValue bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getAssessmentId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("assessment_id=?");
			qi.values.add(bean.getAssessmentId());
			valueSet = true;
		}
		if (bean.getScoreId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("score_id=?");
			qi.values.add(bean.getScoreId());
			valueSet = true;
		}
		if (bean.getScoreName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("score_name=?");
			qi.values.add(bean.getScoreName());
			valueSet = true;
		}
		if (bean.getCanonicalValue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("canonical_value=?");
			qi.values.add(bean.getCanonicalValue());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(CanonicalScoreValue bean,
			CanonicalScoreValue criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_canonical_score_value SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getAssessmentId() != null || bean.isNull("assessmentId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("assessment_id=? ");
			uqi.setValues.add(bean.getAssessmentId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentId"), uqi);
			valueSet = true;
		}
		if (bean.getScoreId() != null || bean.isNull("scoreId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("score_id=? ");
			uqi.setValues.add(bean.getScoreId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("scoreId"), uqi);
			valueSet = true;
		}
		if (bean.getScoreName() != null || bean.isNull("scoreName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("score_name=? ");
			uqi.setValues.add(bean.getScoreName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scoreName"), uqi);
			valueSet = true;
		}
		if (bean.getCanonicalValue() != null || bean.isNull("canonicalValue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("canonical_value=? ");
			uqi.setValues.add(bean.getCanonicalValue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("canonicalValue"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public CanonicalScoreValue createObject(ResultSet rs) throws SQLException {
		CanonicalScoreValue obj = new CanonicalScoreValue();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setAssessmentId((rs.getObject(2) != null) ? new java.math.BigDecimal(
				rs.getObject(2).toString()) : null);
		obj.setScoreId((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setScoreName((String) rs.getObject(4));
		obj.setCanonicalValue((String) rs.getObject(5));
		return obj;
	}

	public List<CanonicalScoreValue> find(Connection con,
			CanonicalScoreValue criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<CanonicalScoreValue> results = new LinkedList<CanonicalScoreValue>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_canonical_score_value ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				CanonicalScoreValue item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, CanonicalScoreValue bean,
			CanonicalScoreValue criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, CanonicalScoreValue criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_canonical_score_value ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
