package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ConfDbuser;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ConfDbuserDAO implements clinical.server.dao.ConfDbuserDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ConfDbuserDAO() {
	}

	public void insert(Connection con, ConfDbuser bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_conf_dbuser VALUES ");
			buf.append('(');
			for (int i = 0; i < 7; ++i) {
				buf.append('?');
				if (i < 6)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueId(), Types.NUMERIC);

			ps.setObject(2, bean.getName(), Types.VARCHAR);

			ps.setObject(3, bean.getPwd(), Types.VARCHAR);

			ps.setObject(4, bean.getDbUniqueId(), Types.NUMERIC);

			ps.setObject(5, bean.getOwner(), Types.NUMERIC);

			ps.setObject(6,
					bean.getModTime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModTime()
									.getTime()));

			ps.setObject(7, bean.getModUser(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(ConfDbuser bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("unique_id");
		buf.append(',');
		buf.append("name");
		buf.append(',');
		buf.append("pwd");
		buf.append(',');
		buf.append("db_unique_id");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("mod_time");
		buf.append(',');
		buf.append("mod_user");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ConfDbuser bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("unique_id=?");
			qi.values.add(bean.getUniqueId());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("name=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getPwd() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("pwd=?");
			qi.values.add(bean.getPwd());
			valueSet = true;
		}
		if (bean.getDbUniqueId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("db_unique_id=?");
			qi.values.add(bean.getDbUniqueId());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("mod_time=?");
			qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("mod_user=?");
			qi.values.add(bean.getModUser());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ConfDbuser bean,
			ConfDbuser criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_conf_dbuser SET ");
		if (bean.getUniqueId() != null || bean.isNull("uniqueId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("unique_id=? ");
			uqi.setValues.add(bean.getUniqueId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueId"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("name=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getPwd() != null || bean.isNull("pwd")) {
			if (valueSet)
				buf.append(", ");
			buf.append("pwd=? ");
			uqi.setValues.add(bean.getPwd());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("pwd"), uqi);
			valueSet = true;
		}
		if (bean.getDbUniqueId() != null || bean.isNull("dbUniqueId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("db_unique_id=? ");
			uqi.setValues.add(bean.getDbUniqueId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("dbUniqueId"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModTime() != null || bean.isNull("modTime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("mod_time=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModTime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modTime"), uqi);
			valueSet = true;
		}
		if (bean.getModUser() != null || bean.isNull("modUser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("mod_user=? ");
			uqi.setValues.add(bean.getModUser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("modUser"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public ConfDbuser createObject(ResultSet rs) throws SQLException {
		ConfDbuser obj = new ConfDbuser();
		obj.setUniqueId((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setName((String) rs.getObject(2));
		obj.setPwd((String) rs.getObject(3));
		obj.setDbUniqueId((rs.getObject(4) != null) ? new java.math.BigDecimal(
				rs.getObject(4).toString()) : null);
		obj.setOwner((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setModTime((rs.getObject(6) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(6)).getTime()) : null);
		obj.setModUser((rs.getObject(7) != null) ? new java.math.BigDecimal(rs
				.getObject(7).toString()) : null);
		return obj;
	}

	public List<ConfDbuser> find(Connection con, ConfDbuser criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ConfDbuser> results = new LinkedList<ConfDbuser>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_conf_dbuser ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ConfDbuser item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ConfDbuser bean, ConfDbuser criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ConfDbuser criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_conf_dbuser ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
