package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ConfRolePrivs;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ConfRolePrivsDAO implements clinical.server.dao.ConfRolePrivsDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ConfRolePrivsDAO() {}

	public void insert(Connection con, ConfRolePrivs bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_conf_role_privs VALUES ");
			buf.append('(');
			for (int i = 0; i < 6; ++i) {
				buf.append('?');
				if (i < 5)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getRoleId(), Types.NUMERIC);

			ps.setObject(2, bean.getPrivName(), Types.VARCHAR);

			ps.setObject(3, bean.getExpId(), Types.NUMERIC);

			ps.setObject(4, bean.getOwner(), Types.NUMERIC);

			ps.setObject(5, bean.getModTime() == null ? (java.sql.Timestamp) null
					: new java.sql.Timestamp(bean.getModTime().getTime()));

			ps.setObject(6, bean.getModUser(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(ConfRolePrivs bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("role_id");
		buf.append(',');
		buf.append("priv_name");
		buf.append(',');
		buf.append("exp_id");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("mod_time");
		buf.append(',');
		buf.append("mod_user");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ConfRolePrivs bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getRoleId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("role_id=?");
			qi.values.add(bean.getRoleId());
			valueSet = true;
		}
		if (bean.getPrivName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("priv_name=?");
			qi.values.add(bean.getPrivName());
			valueSet = true;
		}
		if (bean.getExpId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("exp_id=?");
			qi.values.add(bean.getExpId());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("mod_time=?");
			qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("mod_user=?");
			qi.values.add(bean.getModUser());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ConfRolePrivs bean,
			ConfRolePrivs criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_conf_role_privs SET ");
		if (bean.getRoleId() != null || bean.isNull("roleId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("role_id=? ");
			uqi.setValues.add(bean.getRoleId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("roleId"), uqi);
			valueSet = true;
		}
		if (bean.getPrivName() != null || bean.isNull("privName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("priv_name=? ");
			uqi.setValues.add(bean.getPrivName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("privName"), uqi);
			valueSet = true;
		}
		if (bean.getExpId() != null || bean.isNull("expId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("exp_id=? ");
			uqi.setValues.add(bean.getExpId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("expId"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModTime() != null || bean.isNull("modTime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("mod_time=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModTime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modTime"), uqi);
			valueSet = true;
		}
		if (bean.getModUser() != null || bean.isNull("modUser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("mod_user=? ");
			uqi.setValues.add(bean.getModUser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("modUser"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public ConfRolePrivs createObject(ResultSet rs) throws SQLException {
		ConfRolePrivs obj = new ConfRolePrivs();
		obj.setRoleId((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setPrivName((String) rs.getObject(2));
		obj.setExpId((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setOwner((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setModTime((rs.getObject(5) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(5)).getTime()) : null);
		obj.setModUser((rs.getObject(6) != null) ? new java.math.BigDecimal(rs
				.getObject(6).toString()) : null);
		return obj;
	}

	public List<ConfRolePrivs> find(Connection con, ConfRolePrivs criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ConfRolePrivs> results = new LinkedList<ConfRolePrivs>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_conf_role_privs ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ConfRolePrivs item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ConfRolePrivs bean, ConfRolePrivs criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ConfRolePrivs criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_conf_role_privs ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
