package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ContactInfo;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ContactInfoDAO implements clinical.server.dao.ContactInfoDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ContactInfoDAO() {
	}

	public void insert(Connection con, ContactInfo bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_contact_info VALUES ");
			buf.append('(');
			for (int i = 0; i < 15; ++i) {
				buf.append('?');
				if (i < 14)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getWebuserId(), Types.NUMERIC);

			ps.setObject(3, bean.getInstitution(), Types.VARCHAR);

			ps.setObject(4, bean.getAddressLine(), Types.VARCHAR);

			ps.setObject(5, bean.getState(), Types.VARCHAR);

			ps.setObject(6, bean.getCountry(), Types.VARCHAR);

			ps.setObject(7, bean.getZipCode(), Types.VARCHAR);

			ps.setObject(8, bean.getFirstName(), Types.VARCHAR);

			ps.setObject(9, bean.getLastName(), Types.VARCHAR);

			ps.setObject(10, bean.getAffiliation(), Types.VARCHAR);

			ps.setObject(11, bean.getTitle(), Types.VARCHAR);

			ps.setObject(12, bean.getPhone(), Types.VARCHAR);

			ps.setObject(13, bean.getFax(), Types.VARCHAR);

			ps.setObject(14, bean.getNotes(), Types.VARCHAR);

			ps.setObject(15,
					bean.getModTime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModTime()
									.getTime()));

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(ContactInfo bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("webuser_id");
		buf.append(',');
		buf.append("institution");
		buf.append(',');
		buf.append("address_line");
		buf.append(',');
		buf.append("state");
		buf.append(',');
		buf.append("country");
		buf.append(',');
		buf.append("zip_code");
		buf.append(',');
		buf.append("first_name");
		buf.append(',');
		buf.append("last_name");
		buf.append(',');
		buf.append("affiliation");
		buf.append(',');
		buf.append("title");
		buf.append(',');
		buf.append("phone");
		buf.append(',');
		buf.append("fax");
		buf.append(',');
		buf.append("notes");
		buf.append(',');
		buf.append("mod_time");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ContactInfo bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getWebuserId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("webuser_id=?");
			qi.values.add(bean.getWebuserId());
			valueSet = true;
		}
		if (bean.getInstitution() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("institution=?");
			qi.values.add(bean.getInstitution());
			valueSet = true;
		}
		if (bean.getAddressLine() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("address_line=?");
			qi.values.add(bean.getAddressLine());
			valueSet = true;
		}
		if (bean.getState() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("state=?");
			qi.values.add(bean.getState());
			valueSet = true;
		}
		if (bean.getCountry() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("country=?");
			qi.values.add(bean.getCountry());
			valueSet = true;
		}
		if (bean.getZipCode() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("zip_code=?");
			qi.values.add(bean.getZipCode());
			valueSet = true;
		}
		if (bean.getFirstName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("first_name=?");
			qi.values.add(bean.getFirstName());
			valueSet = true;
		}
		if (bean.getLastName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("last_name=?");
			qi.values.add(bean.getLastName());
			valueSet = true;
		}
		if (bean.getAffiliation() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("affiliation=?");
			qi.values.add(bean.getAffiliation());
			valueSet = true;
		}
		if (bean.getTitle() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("title=?");
			qi.values.add(bean.getTitle());
			valueSet = true;
		}
		if (bean.getPhone() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("phone=?");
			qi.values.add(bean.getPhone());
			valueSet = true;
		}
		if (bean.getFax() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("fax=?");
			qi.values.add(bean.getFax());
			valueSet = true;
		}
		if (bean.getNotes() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("notes=?");
			qi.values.add(bean.getNotes());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("mod_time=?");
			qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ContactInfo bean,
			ContactInfo criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_contact_info SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getWebuserId() != null || bean.isNull("webuserId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("webuser_id=? ");
			uqi.setValues.add(bean.getWebuserId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("webuserId"), uqi);
			valueSet = true;
		}
		if (bean.getInstitution() != null || bean.isNull("institution")) {
			if (valueSet)
				buf.append(", ");
			buf.append("institution=? ");
			uqi.setValues.add(bean.getInstitution());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("institution"), uqi);
			valueSet = true;
		}
		if (bean.getAddressLine() != null || bean.isNull("addressLine")) {
			if (valueSet)
				buf.append(", ");
			buf.append("address_line=? ");
			uqi.setValues.add(bean.getAddressLine());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("addressLine"), uqi);
			valueSet = true;
		}
		if (bean.getState() != null || bean.isNull("state")) {
			if (valueSet)
				buf.append(", ");
			buf.append("state=? ");
			uqi.setValues.add(bean.getState());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("state"), uqi);
			valueSet = true;
		}
		if (bean.getCountry() != null || bean.isNull("country")) {
			if (valueSet)
				buf.append(", ");
			buf.append("country=? ");
			uqi.setValues.add(bean.getCountry());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("country"), uqi);
			valueSet = true;
		}
		if (bean.getZipCode() != null || bean.isNull("zipCode")) {
			if (valueSet)
				buf.append(", ");
			buf.append("zip_code=? ");
			uqi.setValues.add(bean.getZipCode());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("zipCode"), uqi);
			valueSet = true;
		}
		if (bean.getFirstName() != null || bean.isNull("firstName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("first_name=? ");
			uqi.setValues.add(bean.getFirstName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("firstName"), uqi);
			valueSet = true;
		}
		if (bean.getLastName() != null || bean.isNull("lastName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("last_name=? ");
			uqi.setValues.add(bean.getLastName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("lastName"), uqi);
			valueSet = true;
		}
		if (bean.getAffiliation() != null || bean.isNull("affiliation")) {
			if (valueSet)
				buf.append(", ");
			buf.append("affiliation=? ");
			uqi.setValues.add(bean.getAffiliation());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("affiliation"), uqi);
			valueSet = true;
		}
		if (bean.getTitle() != null || bean.isNull("title")) {
			if (valueSet)
				buf.append(", ");
			buf.append("title=? ");
			uqi.setValues.add(bean.getTitle());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("title"), uqi);
			valueSet = true;
		}
		if (bean.getPhone() != null || bean.isNull("phone")) {
			if (valueSet)
				buf.append(", ");
			buf.append("phone=? ");
			uqi.setValues.add(bean.getPhone());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("phone"), uqi);
			valueSet = true;
		}
		if (bean.getFax() != null || bean.isNull("fax")) {
			if (valueSet)
				buf.append(", ");
			buf.append("fax=? ");
			uqi.setValues.add(bean.getFax());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("fax"), uqi);
			valueSet = true;
		}
		if (bean.getNotes() != null || bean.isNull("notes")) {
			if (valueSet)
				buf.append(", ");
			buf.append("notes=? ");
			uqi.setValues.add(bean.getNotes());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("notes"), uqi);
			valueSet = true;
		}
		if (bean.getModTime() != null || bean.isNull("modTime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("mod_time=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModTime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modTime"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public ContactInfo createObject(ResultSet rs) throws SQLException {
		ContactInfo obj = new ContactInfo();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setWebuserId((rs.getObject(2) != null) ? new java.math.BigDecimal(
				rs.getObject(2).toString()) : null);
		obj.setInstitution((String) rs.getObject(3));
		obj.setAddressLine((String) rs.getObject(4));
		obj.setState((String) rs.getObject(5));
		obj.setCountry((String) rs.getObject(6));
		obj.setZipCode((String) rs.getObject(7));
		obj.setFirstName((String) rs.getObject(8));
		obj.setLastName((String) rs.getObject(9));
		obj.setAffiliation((String) rs.getObject(10));
		obj.setTitle((String) rs.getObject(11));
		obj.setPhone((String) rs.getObject(12));
		obj.setFax((String) rs.getObject(13));
		obj.setNotes((String) rs.getObject(14));
		obj.setModTime((rs.getObject(15) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(15)).getTime()) : null);
		return obj;
	}

	public List<ContactInfo> find(Connection con, ContactInfo criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ContactInfo> results = new LinkedList<ContactInfo>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_contact_info ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ContactInfo item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ContactInfo bean, ContactInfo criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ContactInfo criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_contact_info ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
