package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Experiment;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExperimentDAO implements clinical.server.dao.ExperimentDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExperimentDAO() {
	}

	public void insert(Connection con, Experiment bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_experiment VALUES ");
			buf.append('(');
			for (int i = 0; i < 16; ++i) {
				buf.append('?');
				if (i < 15)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getOwner(), Types.NUMERIC);

			ps.setObject(4,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(5, bean.getModuser(), Types.NUMERIC);

			ps.setObject(6, bean.getName(), Types.VARCHAR);

			ps.setObject(7, bean.getDescription(), Types.VARCHAR);

			ps.setObject(8, bean.getContactperson(), Types.NUMERIC);

			ps.setObject(9, bean.getBaseuri(), Types.VARCHAR);

			ps.setObject(10, bean.getIsregressiondata());

			ps.setObject(11, bean.getStoragetype(), Types.VARCHAR);

			ps.setObject(12, bean.getDataSharingAgreed());

			ps.setObject(13, bean.getApproved());

			ps.setObject(14, bean.getIrbFlag());

			ps.setObject(15, bean.getIrbDocLoc(), Types.VARCHAR);

			ps.setObject(16, bean.getContactInfoId(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Experiment bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("name");
		buf.append(',');
		buf.append("description");
		buf.append(',');
		buf.append("contactperson");
		buf.append(',');
		buf.append("baseuri");
		buf.append(',');
		buf.append("isregressiondata");
		buf.append(',');
		buf.append("storagetype");
		buf.append(',');
		buf.append("data_sharing_agreed");
		buf.append(',');
		buf.append("approved");
		buf.append(',');
		buf.append("irb_flag");
		buf.append(',');
		buf.append("irb_doc_loc");
		buf.append(',');
		buf.append("contact_info_id");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Experiment bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("name=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("description=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getContactperson() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("contactperson=?");
			qi.values.add(bean.getContactperson());
			valueSet = true;
		}
		if (bean.getBaseuri() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("baseuri=?");
			qi.values.add(bean.getBaseuri());
			valueSet = true;
		}
		if (bean.getIsregressiondata() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isregressiondata=?");
			qi.values.add(bean.getIsregressiondata());
			valueSet = true;
		}
		if (bean.getStoragetype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("storagetype=?");
			qi.values.add(bean.getStoragetype());
			valueSet = true;
		}
		if (bean.getDataSharingAgreed() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("data_sharing_agreed=?");
			qi.values.add(bean.getDataSharingAgreed());
			valueSet = true;
		}
		if (bean.getApproved() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("approved=?");
			qi.values.add(bean.getApproved());
			valueSet = true;
		}
		if (bean.getIrbFlag() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("irb_flag=?");
			qi.values.add(bean.getIrbFlag());
			valueSet = true;
		}
		if (bean.getIrbDocLoc() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("irb_doc_loc=?");
			qi.values.add(bean.getIrbDocLoc());
			valueSet = true;
		}
		if (bean.getContactInfoId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("contact_info_id=?");
			qi.values.add(bean.getContactInfoId());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Experiment bean,
			Experiment criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_experiment SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("name=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("description=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getContactperson() != null || bean.isNull("contactperson")) {
			if (valueSet)
				buf.append(", ");
			buf.append("contactperson=? ");
			uqi.setValues.add(bean.getContactperson());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("contactperson"), uqi);
			valueSet = true;
		}
		if (bean.getBaseuri() != null || bean.isNull("baseuri")) {
			if (valueSet)
				buf.append(", ");
			buf.append("baseuri=? ");
			uqi.setValues.add(bean.getBaseuri());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("baseuri"), uqi);
			valueSet = true;
		}
		if (bean.getIsregressiondata() != null
				|| bean.isNull("isregressiondata")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isregressiondata=? ");
			uqi.setValues.add(bean.getIsregressiondata());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("isregressiondata"), uqi);
			valueSet = true;
		}
		if (bean.getStoragetype() != null || bean.isNull("storagetype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("storagetype=? ");
			uqi.setValues.add(bean.getStoragetype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("storagetype"), uqi);
			valueSet = true;
		}
		if (bean.getDataSharingAgreed() != null
				|| bean.isNull("dataSharingAgreed")) {
			if (valueSet)
				buf.append(", ");
			buf.append("data_sharing_agreed=? ");
			uqi.setValues.add(bean.getDataSharingAgreed());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("dataSharingAgreed"), uqi);
			valueSet = true;
		}
		if (bean.getApproved() != null || bean.isNull("approved")) {
			if (valueSet)
				buf.append(", ");
			buf.append("approved=? ");
			uqi.setValues.add(bean.getApproved());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("approved"), uqi);
			valueSet = true;
		}
		if (bean.getIrbFlag() != null || bean.isNull("irbFlag")) {
			if (valueSet)
				buf.append(", ");
			buf.append("irb_flag=? ");
			uqi.setValues.add(bean.getIrbFlag());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("irbFlag"), uqi);
			valueSet = true;
		}
		if (bean.getIrbDocLoc() != null || bean.isNull("irbDocLoc")) {
			if (valueSet)
				buf.append(", ");
			buf.append("irb_doc_loc=? ");
			uqi.setValues.add(bean.getIrbDocLoc());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("irbDocLoc"), uqi);
			valueSet = true;
		}
		if (bean.getContactInfoId() != null || bean.isNull("contactInfoId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("contact_info_id=? ");
			uqi.setValues.add(bean.getContactInfoId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("contactInfoId"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Experiment createObject(ResultSet rs) throws SQLException {
		Experiment obj = new Experiment();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setOwner((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setModtime((rs.getObject(4) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(4)).getTime()) : null);
		obj.setModuser((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setName((String) rs.getObject(6));
		obj.setDescription((String) rs.getObject(7));
		obj
				.setContactperson((rs.getObject(8) != null) ? new java.math.BigDecimal(
						rs.getObject(8).toString())
						: null);
		obj.setBaseuri((String) rs.getObject(9));
		obj.setIsregressiondata((Boolean) rs.getObject(10));
		obj.setStoragetype((String) rs.getObject(11));
		obj.setDataSharingAgreed((Boolean) rs.getObject(12));
		obj.setApproved((Boolean) rs.getObject(13));
		obj.setIrbFlag((Boolean) rs.getObject(14));
		obj.setIrbDocLoc((String) rs.getObject(15));
		obj
				.setContactInfoId((rs.getObject(16) != null) ? new java.math.BigDecimal(
						rs.getObject(16).toString())
						: null);
		return obj;
	}

	public List<Experiment> find(Connection con, Experiment criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Experiment> results = new LinkedList<Experiment>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_experiment ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Experiment item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Experiment bean, Experiment criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Experiment criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_experiment ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
