package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Jobs;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class JobsDAO implements clinical.server.dao.JobsDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public JobsDAO() {
	}

	public void insert(Connection con, Jobs bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_jobs VALUES ");
			buf.append('(');
			for (int i = 0; i < 19; ++i) {
				buf.append('?');
				if (i < 18)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getOwner(), Types.NUMERIC);

			ps.setObject(4,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(5, bean.getModuser(), Types.NUMERIC);

			ps.setObject(6, bean.getJobid(), Types.VARCHAR);

			ps.setObject(7, bean.getJobtype(), Types.VARCHAR);

			ps.setObject(8, bean.getJobuser(), Types.VARCHAR);

			ps.setObject(9, bean.getJobstatus(), Types.VARCHAR);

			ps.setObject(10,
					bean.getJobstartdate() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getJobstartdate()
									.getTime()));

			ps.setObject(11,
					bean.getJobenddate() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getJobenddate()
									.getTime()));

			ps.setObject(12, bean.getJobsize(), Types.NUMERIC);

			ps.setObject(13, bean.getDownloadcount(), Types.NUMERIC);

			ps
					.setObject(
							14,
							bean.getLastdownloadtime() == null ? (java.sql.Timestamp) null
									: new java.sql.Timestamp(bean
											.getLastdownloadtime().getTime()));

			ps.setObject(15, bean.getSavedresultfile(), Types.VARCHAR);

			ps.setObject(16, bean.getErrormsg(), Types.VARCHAR);

			ps.setObject(17, bean.getDescription(), Types.VARCHAR);

			ps.setObject(18, bean.getStatusDetail(), Types.VARCHAR);

			ps.setObject(19, bean.getJobContext(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Jobs bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("jobid");
		buf.append(',');
		buf.append("jobtype");
		buf.append(',');
		buf.append("jobuser");
		buf.append(',');
		buf.append("jobstatus");
		buf.append(',');
		buf.append("jobstartdate");
		buf.append(',');
		buf.append("jobenddate");
		buf.append(',');
		buf.append("jobsize");
		buf.append(',');
		buf.append("downloadcount");
		buf.append(',');
		buf.append("lastdownloadtime");
		buf.append(',');
		buf.append("savedresultfile");
		buf.append(',');
		buf.append("errormsg");
		buf.append(',');
		buf.append("description");
		buf.append(',');
		buf.append("status_detail");
		buf.append(',');
		buf.append("job_context");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Jobs bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getJobid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("jobid=?");
			qi.values.add(bean.getJobid());
			valueSet = true;
		}
		if (bean.getJobtype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("jobtype=?");
			qi.values.add(bean.getJobtype());
			valueSet = true;
		}
		if (bean.getJobuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("jobuser=?");
			qi.values.add(bean.getJobuser());
			valueSet = true;
		}
		if (bean.getJobstatus() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("jobstatus=?");
			qi.values.add(bean.getJobstatus());
			valueSet = true;
		}
		if (bean.getJobstartdate() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("jobstartdate=?");
			qi.values.add(new java.sql.Date(bean.getJobstartdate().getTime()));
			valueSet = true;
		}
		if (bean.getJobenddate() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("jobenddate=?");
			qi.values.add(new java.sql.Date(bean.getJobenddate().getTime()));
			valueSet = true;
		}
		if (bean.getJobsize() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("jobsize=?");
			qi.values.add(bean.getJobsize());
			valueSet = true;
		}
		if (bean.getDownloadcount() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("downloadcount=?");
			qi.values.add(bean.getDownloadcount());
			valueSet = true;
		}
		if (bean.getLastdownloadtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("lastdownloadtime=?");
			qi.values.add(new java.sql.Date(bean.getLastdownloadtime()
					.getTime()));
			valueSet = true;
		}
		if (bean.getSavedresultfile() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("savedresultfile=?");
			qi.values.add(bean.getSavedresultfile());
			valueSet = true;
		}
		if (bean.getErrormsg() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("errormsg=?");
			qi.values.add(bean.getErrormsg());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("description=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getStatusDetail() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("status_detail=?");
			qi.values.add(bean.getStatusDetail());
			valueSet = true;
		}
		if (bean.getJobContext() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("job_context=?");
			qi.values.add(bean.getJobContext());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Jobs bean, Jobs criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_jobs SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getJobid() != null || bean.isNull("jobid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("jobid=? ");
			uqi.setValues.add(bean.getJobid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("jobid"), uqi);
			valueSet = true;
		}
		if (bean.getJobtype() != null || bean.isNull("jobtype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("jobtype=? ");
			uqi.setValues.add(bean.getJobtype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("jobtype"), uqi);
			valueSet = true;
		}
		if (bean.getJobuser() != null || bean.isNull("jobuser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("jobuser=? ");
			uqi.setValues.add(bean.getJobuser());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("jobuser"), uqi);
			valueSet = true;
		}
		if (bean.getJobstatus() != null || bean.isNull("jobstatus")) {
			if (valueSet)
				buf.append(", ");
			buf.append("jobstatus=? ");
			uqi.setValues.add(bean.getJobstatus());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("jobstatus"), uqi);
			valueSet = true;
		}
		if (bean.getJobstartdate() != null || bean.isNull("jobstartdate")) {
			if (valueSet)
				buf.append(", ");
			buf.append("jobstartdate=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getJobstartdate()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("jobstartdate"), uqi);
			valueSet = true;
		}
		if (bean.getJobenddate() != null || bean.isNull("jobenddate")) {
			if (valueSet)
				buf.append(", ");
			buf.append("jobenddate=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getJobenddate()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("jobenddate"), uqi);
			valueSet = true;
		}
		if (bean.getJobsize() != null || bean.isNull("jobsize")) {
			if (valueSet)
				buf.append(", ");
			buf.append("jobsize=? ");
			uqi.setValues.add(bean.getJobsize());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("jobsize"), uqi);
			valueSet = true;
		}
		if (bean.getDownloadcount() != null || bean.isNull("downloadcount")) {
			if (valueSet)
				buf.append(", ");
			buf.append("downloadcount=? ");
			uqi.setValues.add(bean.getDownloadcount());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("downloadcount"), uqi);
			valueSet = true;
		}
		if (bean.getLastdownloadtime() != null
				|| bean.isNull("lastdownloadtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("lastdownloadtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getLastdownloadtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("lastdownloadtime"), uqi);
			valueSet = true;
		}
		if (bean.getSavedresultfile() != null || bean.isNull("savedresultfile")) {
			if (valueSet)
				buf.append(", ");
			buf.append("savedresultfile=? ");
			uqi.setValues.add(bean.getSavedresultfile());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("savedresultfile"), uqi);
			valueSet = true;
		}
		if (bean.getErrormsg() != null || bean.isNull("errormsg")) {
			if (valueSet)
				buf.append(", ");
			buf.append("errormsg=? ");
			uqi.setValues.add(bean.getErrormsg());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("errormsg"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("description=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getStatusDetail() != null || bean.isNull("statusDetail")) {
			if (valueSet)
				buf.append(", ");
			buf.append("status_detail=? ");
			uqi.setValues.add(bean.getStatusDetail());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("statusDetail"), uqi);
			valueSet = true;
		}
		if (bean.getJobContext() != null || bean.isNull("jobContext")) {
			if (valueSet)
				buf.append(", ");
			buf.append("job_context=? ");
			uqi.setValues.add(bean.getJobContext());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("jobContext"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Jobs createObject(ResultSet rs) throws SQLException {
		Jobs obj = new Jobs();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setOwner((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setModtime((rs.getObject(4) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(4)).getTime()) : null);
		obj.setModuser((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setJobid((String) rs.getObject(6));
		obj.setJobtype((String) rs.getObject(7));
		obj.setJobuser((String) rs.getObject(8));
		obj.setJobstatus((String) rs.getObject(9));
		obj.setJobstartdate((rs.getObject(10) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(10)).getTime()) : null);
		obj.setJobenddate((rs.getObject(11) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(11)).getTime()) : null);
		obj.setJobsize((rs.getObject(12) != null) ? new java.math.BigDecimal(rs
				.getObject(12).toString()) : null);
		obj
				.setDownloadcount((rs.getObject(13) != null) ? new java.math.BigDecimal(
						rs.getObject(13).toString())
						: null);
		obj
				.setLastdownloadtime((rs.getObject(14) != null) ? new java.util.Date(
						((java.sql.Timestamp) rs.getObject(14)).getTime())
						: null);
		obj.setSavedresultfile((String) rs.getObject(15));
		obj.setErrormsg((String) rs.getObject(16));
		obj.setDescription((String) rs.getObject(17));
		obj.setStatusDetail((String) rs.getObject(18));
		obj.setJobContext((String) rs.getObject(19));
		return obj;
	}

	public List<Jobs> find(Connection con, Jobs criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Jobs> results = new LinkedList<Jobs>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_jobs ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Jobs item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Jobs bean, Jobs criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Jobs criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_jobs ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
