package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Measurementunit;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class MeasurementunitDAO implements
		clinical.server.dao.MeasurementunitDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public MeasurementunitDAO() {
	}

	public void insert(Connection con, Measurementunit bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_measurementunit VALUES ");
			buf.append('(');
			for (int i = 0; i < 12; ++i) {
				buf.append('?');
				if (i < 11)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getMeasurementsystem(), Types.VARCHAR);

			ps.setObject(2, bean.getUnit(), Types.VARCHAR);

			ps.setObject(3, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(4, bean.getTableid(), Types.NUMERIC);

			ps.setObject(5, bean.getOwner(), Types.NUMERIC);

			ps.setObject(6,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(7, bean.getModuser(), Types.NUMERIC);

			ps.setObject(8, bean.getMeasurementtype(), Types.VARCHAR);

			ps.setObject(9, bean.getConversionsystem(), Types.VARCHAR);

			ps.setObject(10, bean.getConversionunit(), Types.VARCHAR);

			ps.setObject(11, bean.getConversioninfo(), Types.VARCHAR);

			ps.setObject(12, bean.getDescription(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Measurementunit bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("measurementsystem");
		buf.append(',');
		buf.append("unit");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("measurementtype");
		buf.append(',');
		buf.append("conversionsystem");
		buf.append(',');
		buf.append("conversionunit");
		buf.append(',');
		buf.append("conversioninfo");
		buf.append(',');
		buf.append("description");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Measurementunit bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getMeasurementsystem() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("measurementsystem=?");
			qi.values.add(bean.getMeasurementsystem());
			valueSet = true;
		}
		if (bean.getUnit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("unit=?");
			qi.values.add(bean.getUnit());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getMeasurementtype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("measurementtype=?");
			qi.values.add(bean.getMeasurementtype());
			valueSet = true;
		}
		if (bean.getConversionsystem() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("conversionsystem=?");
			qi.values.add(bean.getConversionsystem());
			valueSet = true;
		}
		if (bean.getConversionunit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("conversionunit=?");
			qi.values.add(bean.getConversionunit());
			valueSet = true;
		}
		if (bean.getConversioninfo() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("conversioninfo=?");
			qi.values.add(bean.getConversioninfo());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("description=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Measurementunit bean,
			Measurementunit criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_measurementunit SET ");
		if (bean.getMeasurementsystem() != null
				|| bean.isNull("measurementsystem")) {
			if (valueSet)
				buf.append(", ");
			buf.append("measurementsystem=? ");
			uqi.setValues.add(bean.getMeasurementsystem());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementsystem"), uqi);
			valueSet = true;
		}
		if (bean.getUnit() != null || bean.isNull("unit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("unit=? ");
			uqi.setValues.add(bean.getUnit());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("unit"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementtype() != null || bean.isNull("measurementtype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("measurementtype=? ");
			uqi.setValues.add(bean.getMeasurementtype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementtype"), uqi);
			valueSet = true;
		}
		if (bean.getConversionsystem() != null
				|| bean.isNull("conversionsystem")) {
			if (valueSet)
				buf.append(", ");
			buf.append("conversionsystem=? ");
			uqi.setValues.add(bean.getConversionsystem());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conversionsystem"), uqi);
			valueSet = true;
		}
		if (bean.getConversionunit() != null || bean.isNull("conversionunit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("conversionunit=? ");
			uqi.setValues.add(bean.getConversionunit());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conversionunit"), uqi);
			valueSet = true;
		}
		if (bean.getConversioninfo() != null || bean.isNull("conversioninfo")) {
			if (valueSet)
				buf.append(", ");
			buf.append("conversioninfo=? ");
			uqi.setValues.add(bean.getConversioninfo());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conversioninfo"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("description=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Measurementunit createObject(ResultSet rs) throws SQLException {
		Measurementunit obj = new Measurementunit();
		obj.setMeasurementsystem((String) rs.getObject(1));
		obj.setUnit((String) rs.getObject(2));
		obj.setUniqueid((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setTableid((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setOwner((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setModtime((rs.getObject(6) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(6)).getTime()) : null);
		obj.setModuser((rs.getObject(7) != null) ? new java.math.BigDecimal(rs
				.getObject(7).toString()) : null);
		obj.setMeasurementtype((String) rs.getObject(8));
		obj.setConversionsystem((String) rs.getObject(9));
		obj.setConversionunit((String) rs.getObject(10));
		obj.setConversioninfo((String) rs.getObject(11));
		obj.setDescription((String) rs.getObject(12));
		return obj;
	}

	public List<Measurementunit> find(Connection con, Measurementunit criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Measurementunit> results = new LinkedList<Measurementunit>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_measurementunit ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Measurementunit item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Measurementunit bean,
			Measurementunit criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Measurementunit criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_measurementunit ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
