package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Person;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class PersonDAO implements clinical.server.dao.PersonDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public PersonDAO() {
	}

	public void insert(Connection con, Person bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_person VALUES ");
			buf.append('(');
			for (int i = 0; i < 8; ++i) {
				buf.append('?');
				if (i < 7)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getOwner(), Types.NUMERIC);

			ps.setObject(4,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(5, bean.getModuser(), Types.NUMERIC);

			ps.setObject(6, bean.getFirstName(), Types.VARCHAR);

			ps.setObject(7, bean.getLastName(), Types.VARCHAR);

			ps.setObject(8, bean.getEmail(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Person bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("first_name");
		buf.append(',');
		buf.append("last_name");
		buf.append(',');
		buf.append("email");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Person bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getFirstName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("first_name=?");
			qi.values.add(bean.getFirstName());
			valueSet = true;
		}
		if (bean.getLastName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("last_name=?");
			qi.values.add(bean.getLastName());
			valueSet = true;
		}
		if (bean.getEmail() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("email=?");
			qi.values.add(bean.getEmail());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Person bean, Person criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_person SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getFirstName() != null || bean.isNull("firstName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("first_name=? ");
			uqi.setValues.add(bean.getFirstName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("firstName"), uqi);
			valueSet = true;
		}
		if (bean.getLastName() != null || bean.isNull("lastName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("last_name=? ");
			uqi.setValues.add(bean.getLastName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("lastName"), uqi);
			valueSet = true;
		}
		if (bean.getEmail() != null || bean.isNull("email")) {
			if (valueSet)
				buf.append(", ");
			buf.append("email=? ");
			uqi.setValues.add(bean.getEmail());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("email"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Person createObject(ResultSet rs) throws SQLException {
		Person obj = new Person();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setOwner((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setModtime((rs.getObject(4) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(4)).getTime()) : null);
		obj.setModuser((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setFirstName((String) rs.getObject(6));
		obj.setLastName((String) rs.getObject(7));
		obj.setEmail((String) rs.getObject(8));
		return obj;
	}

	public List<Person> find(Connection con, Person criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Person> results = new LinkedList<Person>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_person ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Person item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Person bean, Person criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Person criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_person ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
