package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ScoreSynonyms;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ScoreSynonymsDAO implements clinical.server.dao.ScoreSynonymsDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ScoreSynonymsDAO() {
	}

	public void insert(Connection con, ScoreSynonyms bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_score_synonyms VALUES ");
			buf.append('(');
			for (int i = 0; i < 9; ++i) {
				buf.append('?');
				if (i < 8)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getAssessmentId(), Types.NUMERIC);

			ps.setObject(3, bean.getScoreId(), Types.NUMERIC);

			ps.setObject(4, bean.getScoreName(), Types.VARCHAR);

			ps.setObject(5, bean.getCanonicalValue(), Types.VARCHAR);

			ps.setObject(6, bean.getSynonyms(), Types.VARCHAR);

			ps.setObject(7, bean.getAppliesglobal());

			ps.setObject(8,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(9, bean.getModuser(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(ScoreSynonyms bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("assessment_id");
		buf.append(',');
		buf.append("score_id");
		buf.append(',');
		buf.append("score_name");
		buf.append(',');
		buf.append("canonical_value");
		buf.append(',');
		buf.append("synonyms");
		buf.append(',');
		buf.append("appliesglobal");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ScoreSynonyms bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getAssessmentId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("assessment_id=?");
			qi.values.add(bean.getAssessmentId());
			valueSet = true;
		}
		if (bean.getScoreId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("score_id=?");
			qi.values.add(bean.getScoreId());
			valueSet = true;
		}
		if (bean.getScoreName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("score_name=?");
			qi.values.add(bean.getScoreName());
			valueSet = true;
		}
		if (bean.getCanonicalValue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("canonical_value=?");
			qi.values.add(bean.getCanonicalValue());
			valueSet = true;
		}
		if (bean.getSynonyms() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("synonyms=?");
			qi.values.add(bean.getSynonyms());
			valueSet = true;
		}
		if (bean.getAppliesglobal() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("appliesglobal=?");
			qi.values.add(bean.getAppliesglobal());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ScoreSynonyms bean,
			ScoreSynonyms criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_score_synonyms SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getAssessmentId() != null || bean.isNull("assessmentId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("assessment_id=? ");
			uqi.setValues.add(bean.getAssessmentId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentId"), uqi);
			valueSet = true;
		}
		if (bean.getScoreId() != null || bean.isNull("scoreId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("score_id=? ");
			uqi.setValues.add(bean.getScoreId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("scoreId"), uqi);
			valueSet = true;
		}
		if (bean.getScoreName() != null || bean.isNull("scoreName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("score_name=? ");
			uqi.setValues.add(bean.getScoreName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scoreName"), uqi);
			valueSet = true;
		}
		if (bean.getCanonicalValue() != null || bean.isNull("canonicalValue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("canonical_value=? ");
			uqi.setValues.add(bean.getCanonicalValue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("canonicalValue"), uqi);
			valueSet = true;
		}
		if (bean.getSynonyms() != null || bean.isNull("synonyms")) {
			if (valueSet)
				buf.append(", ");
			buf.append("synonyms=? ");
			uqi.setValues.add(bean.getSynonyms());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("synonyms"), uqi);
			valueSet = true;
		}
		if (bean.getAppliesglobal() != null || bean.isNull("appliesglobal")) {
			if (valueSet)
				buf.append(", ");
			buf.append("appliesglobal=? ");
			uqi.setValues.add(bean.getAppliesglobal());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("appliesglobal"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public ScoreSynonyms createObject(ResultSet rs) throws SQLException {
		ScoreSynonyms obj = new ScoreSynonyms();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setAssessmentId((rs.getObject(2) != null) ? new java.math.BigDecimal(
				rs.getObject(2).toString()) : null);
		obj.setScoreId((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setScoreName((String) rs.getObject(4));
		obj.setCanonicalValue((String) rs.getObject(5));
		obj.setSynonyms((String) rs.getObject(6));
		obj.setAppliesglobal((Boolean) rs.getObject(7));
		obj.setModtime((rs.getObject(8) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(8)).getTime()) : null);
		obj.setModuser((rs.getObject(9) != null) ? new java.math.BigDecimal(rs
				.getObject(9).toString()) : null);
		return obj;
	}

	public List<ScoreSynonyms> find(Connection con, ScoreSynonyms criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ScoreSynonyms> results = new LinkedList<ScoreSynonyms>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_score_synonyms ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ScoreSynonyms item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ScoreSynonyms bean,
			ScoreSynonyms criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ScoreSynonyms criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_score_synonyms ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
