package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ScoreValueMapping;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ScoreValueMappingDAO implements
		clinical.server.dao.ScoreValueMappingDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ScoreValueMappingDAO() {
	}

	public void insert(Connection con, ScoreValueMapping bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_score_value_mapping VALUES ");
			buf.append('(');
			for (int i = 0; i < 3; ++i) {
				buf.append('?');
				if (i < 2)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getCanonicalScoreValueId(), Types.NUMERIC);

			ps.setObject(3, bean.getScoreValue(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(ScoreValueMapping bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("canonical_score_value_id");
		buf.append(',');
		buf.append("score_value");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ScoreValueMapping bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getCanonicalScoreValueId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("canonical_score_value_id=?");
			qi.values.add(bean.getCanonicalScoreValueId());
			valueSet = true;
		}
		if (bean.getScoreValue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("score_value=?");
			qi.values.add(bean.getScoreValue());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ScoreValueMapping bean,
			ScoreValueMapping criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_score_value_mapping SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getCanonicalScoreValueId() != null
				|| bean.isNull("canonicalScoreValueId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("canonical_score_value_id=? ");
			uqi.setValues.add(bean.getCanonicalScoreValueId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("canonicalScoreValueId"), uqi);
			valueSet = true;
		}
		if (bean.getScoreValue() != null || bean.isNull("scoreValue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("score_value=? ");
			uqi.setValues.add(bean.getScoreValue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scoreValue"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public ScoreValueMapping createObject(ResultSet rs) throws SQLException {
		ScoreValueMapping obj = new ScoreValueMapping();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setCanonicalScoreValueId((rs.getObject(2) != null) ? new java.math.BigDecimal(
				rs.getObject(2).toString()) : null);
		obj.setScoreValue((String) rs.getObject(3));
		return obj;
	}

	public List<ScoreValueMapping> find(Connection con,
			ScoreValueMapping criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ScoreValueMapping> results = new LinkedList<ScoreValueMapping>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_score_value_mapping ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ScoreValueMapping item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ScoreValueMapping bean,
			ScoreValueMapping criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ScoreValueMapping criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_score_value_mapping ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
