package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.PostgresUtils;
import clinical.server.vo.Scorevalidation;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ScorevalidationDAO implements
		clinical.server.dao.ScorevalidationDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ScorevalidationDAO() {
	}

	public void insert(Connection con, Scorevalidation bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_scorevalidation VALUES ");
			buf.append('(');
			for (int i = 0; i < 12; ++i) {
				buf.append('?');
				if (i < 11)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getDatatable(), Types.NUMERIC);

			ps.setObject(2, bean.getDataid(), Types.NUMERIC);

			ps.setObject(3, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(4, bean.getTableid(), Types.NUMERIC);

			ps.setObject(5, bean.getOwner(), Types.NUMERIC);

			ps.setObject(6,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(7, bean.getModuser(), Types.NUMERIC);

			ps.setObject(8, bean.getTimestamp());

			ps.setObject(9, bean.getComments(), Types.VARCHAR);

			ps.setObject(10, bean.getValidatorid(), Types.NUMERIC);

			ps.setObject(11, bean.getAssessmentid(), Types.NUMERIC);

			ps.setObject(12, bean.getMethod(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Scorevalidation bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("datatable");
		buf.append(',');
		buf.append("dataid");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("timestamp");
		buf.append(',');
		buf.append("comments");
		buf.append(',');
		buf.append("validatorid");
		buf.append(',');
		buf.append("assessmentid");
		buf.append(',');
		buf.append("method");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Scorevalidation bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getDatatable() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("datatable=?");
			qi.values.add(bean.getDatatable());
			valueSet = true;
		}
		if (bean.getDataid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("dataid=?");
			qi.values.add(bean.getDataid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getTimestamp() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("timestamp=?");
			qi.values.add(bean.getTimestamp());
			valueSet = true;
		}
		if (bean.getComments() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("comments=?");
			qi.values.add(bean.getComments());
			valueSet = true;
		}
		if (bean.getValidatorid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("validatorid=?");
			qi.values.add(bean.getValidatorid());
			valueSet = true;
		}
		if (bean.getAssessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("assessmentid=?");
			qi.values.add(bean.getAssessmentid());
			valueSet = true;
		}
		if (bean.getMethod() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("method=?");
			qi.values.add(bean.getMethod());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Scorevalidation bean,
			Scorevalidation criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_scorevalidation SET ");
		if (bean.getDatatable() != null || bean.isNull("datatable")) {
			if (valueSet)
				buf.append(", ");
			buf.append("datatable=? ");
			uqi.setValues.add(bean.getDatatable());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("datatable"), uqi);
			valueSet = true;
		}
		if (bean.getDataid() != null || bean.isNull("dataid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("dataid=? ");
			uqi.setValues.add(bean.getDataid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("dataid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getTimestamp() != null || bean.isNull("timestamp")) {
			if (valueSet)
				buf.append(", ");
			buf.append("timestamp=? ");
			uqi.setValues.add(bean.getTimestamp());
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("timestamp"), uqi);
			valueSet = true;
		}
		if (bean.getComments() != null || bean.isNull("comments")) {
			if (valueSet)
				buf.append(", ");
			buf.append("comments=? ");
			uqi.setValues.add(bean.getComments());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("comments"), uqi);
			valueSet = true;
		}
		if (bean.getValidatorid() != null || bean.isNull("validatorid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("validatorid=? ");
			uqi.setValues.add(bean.getValidatorid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("validatorid"), uqi);
			valueSet = true;
		}
		if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("assessmentid=? ");
			uqi.setValues.add(bean.getAssessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getMethod() != null || bean.isNull("method")) {
			if (valueSet)
				buf.append(", ");
			buf.append("method=? ");
			uqi.setValues.add(bean.getMethod());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("method"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Scorevalidation createObject(ResultSet rs) throws SQLException {
		Scorevalidation obj = new Scorevalidation();
		obj.setDatatable((rs.getObject(1) != null) ? new java.math.BigDecimal(
				rs.getObject(1).toString()) : null);
		obj.setDataid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setUniqueid((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setTableid((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setOwner((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setModtime((rs.getObject(6) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(6)).getTime()) : null);
		obj.setModuser((rs.getObject(7) != null) ? new java.math.BigDecimal(rs
				.getObject(7).toString()) : null);
		obj.setTimestamp(PostgresUtils.toTimestamp(rs.getObject(8)));
		obj.setComments((String) rs.getObject(9));
		obj
				.setValidatorid((rs.getObject(10) != null) ? new java.math.BigDecimal(
						rs.getObject(10).toString())
						: null);
		obj
				.setAssessmentid((rs.getObject(11) != null) ? new java.math.BigDecimal(
						rs.getObject(11).toString())
						: null);
		obj.setMethod((String) rs.getObject(12));
		return obj;
	}

	public List<Scorevalidation> find(Connection con, Scorevalidation criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Scorevalidation> results = new LinkedList<Scorevalidation>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_scorevalidation ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Scorevalidation item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Scorevalidation bean,
			Scorevalidation criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Scorevalidation criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_scorevalidation ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
