














package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.UploadStatus;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class UploadStatusDAO implements clinical.server.dao.UploadStatusDAO {
/*+++    */
  // Enter your declarations here
/*+++    */

public UploadStatusDAO () {}

	public void insert(Connection con, UploadStatus bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_upload_status VALUES ");
			buf.append('(');
			for (int i = 0; i < 12; ++i) {
				buf.append('?');
				if (i < 11)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getName(), Types.VARCHAR);

			ps.setObject(3, bean.getStagingPath(), Types.VARCHAR);

			ps.setObject(4, bean.getUploadPath(), Types.VARCHAR);

			ps.setObject(5, bean.getStatusCode(), Types.VARCHAR);

			ps.setObject(6, bean.getDescr(), Types.VARCHAR);

			ps.setObject(7, bean.getWebUser(), Types.VARCHAR);

			ps.setObject(8, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(9, bean.getExperimentId(), Types.NUMERIC);

			ps.setObject(10, bean.getOwner(), Types.NUMERIC);

			ps.setObject(11,
					bean.getModTime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModTime()
									.getTime()));

			ps.setObject(12, bean.getModUser(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}


protected String prepareColList(UploadStatus bean) {
  StringBuffer buf = new StringBuffer(200);
    buf.append("uniqueid" );
   buf.append(',');     buf.append("name" );
   buf.append(',');     buf.append("staging_path" );
   buf.append(',');     buf.append("upload_path" );
   buf.append(',');     buf.append("status_code" );
   buf.append(',');     buf.append("descr" );
   buf.append(',');     buf.append("web_user" );
   buf.append(',');     buf.append("subjectid" );
   buf.append(',');     buf.append("experiment_id" );
   buf.append(',');     buf.append("owner" );
   buf.append(',');     buf.append("mod_time" );
   buf.append(',');     buf.append("mod_user" );
      buf.append(' ');
  return buf.toString();
}

protected QueryInfo prepareWhereClause(UploadStatus bean) {
  StringBuffer buf = new StringBuffer(200);
    QueryInfo qi = new QueryInfo();
  boolean valueSet = false;
  buf.append("WHERE ");
    if (bean.getUniqueid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("uniqueid=?");
                   qi.values.add(bean.getUniqueid());
                 valueSet = true;
  }
    if (bean.getName() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("name=?");
                   qi.values.add(bean.getName());
                 valueSet = true;
  }
    if (bean.getStagingPath() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("staging_path=?");
                   qi.values.add(bean.getStagingPath());
                 valueSet = true;
  }
    if (bean.getUploadPath() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("upload_path=?");
                   qi.values.add(bean.getUploadPath());
                 valueSet = true;
  }
    if (bean.getStatusCode() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("status_code=?");
                   qi.values.add(bean.getStatusCode());
                 valueSet = true;
  }
    if (bean.getDescr() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("descr=?");
                   qi.values.add(bean.getDescr());
                 valueSet = true;
  }
    if (bean.getWebUser() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("web_user=?");
                   qi.values.add(bean.getWebUser());
                 valueSet = true;
  }
    if (bean.getSubjectid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("subjectid=?");
                   qi.values.add(bean.getSubjectid());
                 valueSet = true;
  }
    if (bean.getExperimentId() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("experiment_id=?");
                   qi.values.add(bean.getExperimentId());
                 valueSet = true;
  }
    if (bean.getOwner() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("owner=?");
                   qi.values.add(bean.getOwner());
                 valueSet = true;
  }
    if (bean.getModTime() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("mod_time=?");
                   qi.values.add( new java.sql.Date( bean.getModTime().getTime() ));
                 valueSet = true;
  }
    if (bean.getModUser() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("mod_user=?");
                   qi.values.add(bean.getModUser());
                 valueSet = true;
  }
    qi.whereClause = (!valueSet) ? "" : buf.toString();
  return qi;
}

protected UpdateQueryInfo prepareUpdateQuery(UploadStatus bean,UploadStatus criteria ) throws ValidationException
{
  StringBuffer buf = new StringBuffer(200);
    UpdateQueryInfo uqi = new UpdateQueryInfo();
  boolean valueSet = false;
  buf.append("UPDATE nc_upload_status SET ");
    if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
    if (valueSet)  buf.append(", ");
    buf.append("uniqueid=? ");
                    uqi.setValues.add(bean.getUniqueid()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("uniqueid"), uqi);
     valueSet = true;
  }
    if (bean.getName() != null || bean.isNull("name")) {
    if (valueSet)  buf.append(", ");
    buf.append("name=? ");
                    uqi.setValues.add(bean.getName()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("name"), uqi);
     valueSet = true;
  }
    if (bean.getStagingPath() != null || bean.isNull("stagingPath")) {
    if (valueSet)  buf.append(", ");
    buf.append("staging_path=? ");
                    uqi.setValues.add(bean.getStagingPath()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("stagingPath"), uqi);
     valueSet = true;
  }
    if (bean.getUploadPath() != null || bean.isNull("uploadPath")) {
    if (valueSet)  buf.append(", ");
    buf.append("upload_path=? ");
                    uqi.setValues.add(bean.getUploadPath()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("uploadPath"), uqi);
     valueSet = true;
  }
    if (bean.getStatusCode() != null || bean.isNull("statusCode")) {
    if (valueSet)  buf.append(", ");
    buf.append("status_code=? ");
                    uqi.setValues.add(bean.getStatusCode()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("statusCode"), uqi);
     valueSet = true;
  }
    if (bean.getDescr() != null || bean.isNull("descr")) {
    if (valueSet)  buf.append(", ");
    buf.append("descr=? ");
                    uqi.setValues.add(bean.getDescr()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("descr"), uqi);
     valueSet = true;
  }
    if (bean.getWebUser() != null || bean.isNull("webUser")) {
    if (valueSet)  buf.append(", ");
    buf.append("web_user=? ");
                    uqi.setValues.add(bean.getWebUser()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("webUser"), uqi);
     valueSet = true;
  }
    if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
    if (valueSet)  buf.append(", ");
    buf.append("subjectid=? ");
                    uqi.setValues.add(bean.getSubjectid()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("subjectid"), uqi);
     valueSet = true;
  }
    if (bean.getExperimentId() != null || bean.isNull("experimentId")) {
    if (valueSet)  buf.append(", ");
    buf.append("experiment_id=? ");
                    uqi.setValues.add(bean.getExperimentId()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("experimentId"), uqi);
     valueSet = true;
  }
    if (bean.getOwner() != null || bean.isNull("owner")) {
    if (valueSet)  buf.append(", ");
    buf.append("owner=? ");
                    uqi.setValues.add(bean.getOwner()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("owner"), uqi);
     valueSet = true;
  }
    if (bean.getModTime() != null || bean.isNull("modTime")) {
    if (valueSet)  buf.append(", ");
    buf.append("mod_time=? ");
                  uqi.setValues.add( new java.sql.Timestamp( bean.getModTime().getTime() ) );
                 uqi.sqlTypes.add(new Integer( Types.TIMESTAMP ) );
     prepareNullSetListValue( bean.isNull("modTime"), uqi);
     valueSet = true;
  }
    if (bean.getModUser() != null || bean.isNull("modUser")) {
    if (valueSet)  buf.append(", ");
    buf.append("mod_user=? ");
                    uqi.setValues.add(bean.getModUser()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("modUser"), uqi);
     valueSet = true;
  }
    if (!valueSet)
    throw new ValidationException("At least one field needs to be set for update!");

  uqi.query = buf.toString();
  QueryInfo qi = prepareWhereClause(criteria);
  uqi.query += qi.whereClause;
  uqi.whereValues = qi.values;
  return uqi;
}

protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
     if ( wasNull ) {
       uqi.nullSetList.add( new Boolean(true) );
     } else {
       uqi.nullSetList.add( new Boolean(false) );
     }
}


public UploadStatus createObject(ResultSet rs) throws SQLException {
   UploadStatus obj = new UploadStatus();
                  obj.setUniqueid( ( rs.getObject(1) != null) ?
              new java.math.BigDecimal( rs.getObject(1).toString() ) : null );
                            obj.setName( (String ) rs.getObject(2) );
                                   obj.setStagingPath( (String ) rs.getObject(3) );
                                   obj.setUploadPath( (String ) rs.getObject(4) );
                                   obj.setStatusCode( (String ) rs.getObject(5) );
                                   obj.setDescr( (String ) rs.getObject(6) );
                                   obj.setWebUser( (String ) rs.getObject(7) );
                                   obj.setSubjectid( (String ) rs.getObject(8) );
                               obj.setExperimentId( ( rs.getObject(9) != null) ?
              new java.math.BigDecimal( rs.getObject(9).toString() ) : null );
                        obj.setOwner( ( rs.getObject(10) != null) ?
              new java.math.BigDecimal( rs.getObject(10).toString() ) : null );
                                            obj.setModTime( ( rs.getObject(11) != null) ?
              new java.util.Date( ((java.sql.Timestamp) rs.getObject(11)).getTime() ) : null );
                                            obj.setModUser( ( rs.getObject(12) != null) ?
              new java.math.BigDecimal( rs.getObject(12).toString() ) : null );
            return obj;
}

public List<UploadStatus> find(Connection con, UploadStatus criteria) throws Exception
{

   PreparedStatement ps = null;
   ResultSet rs = null;
   List<UploadStatus> results = new LinkedList<UploadStatus>();
   StringBuffer buf = new StringBuffer(200);

   if ( criteria  == null)
       return null;
   buf.append("SELECT ");
   buf.append( prepareColList( criteria) );
   buf.append(" FROM nc_upload_status ");
   QueryInfo qi = prepareWhereClause(criteria);
   buf.append( qi.whereClause );
   try {
      ps = con.prepareStatement( buf.toString() );
      ps.clearParameters();
      int i = 0;
      for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
         ps.setObject(++i, it.next() );
      }
      rs = ps.executeQuery();
      while(rs.next() ) {
          UploadStatus item = createObject(rs);
          results.add(item);
      }
   } finally {
      DBUtils.close(ps, rs);	
   }
   return results;
}

public void update(Connection con, UploadStatus bean, UploadStatus criteria) throws Exception
{
   PreparedStatement ps = null;

   if ( bean  == null)
       return;

   UpdateQueryInfo uqi =  prepareUpdateQuery(bean, criteria);
   try {
       ps = con.prepareStatement( uqi.query );
       ps.clearParameters();
       int i = 0;
       Iterator<Integer> it2 = uqi.sqlTypes.iterator();
       Iterator<Boolean> it3 = uqi.nullSetList.iterator();
       for(Iterator<?> it = uqi.setValues.iterator(); it.hasNext(); ) {
          Object value = it.next();
          Integer sqlType = (Integer) it2.next();
          boolean nullSet = ((Boolean) it3.next()).booleanValue();
          if ( nullSet) {
            ps.setNull(++i, sqlType.intValue() );
          } else {
             ps.setObject(++i, value);
          }
       }
       // for where part
       for(Iterator<?> it = uqi.whereValues.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();
   } finally {
      DBUtils.close(ps);	      
   }
}

public void delete(Connection con, UploadStatus criteria) throws Exception
{
    PreparedStatement ps = null;
    StringBuffer buf = new StringBuffer(200);
    buf.append("DELETE FROM nc_upload_status ");

    QueryInfo qi = prepareWhereClause(criteria);
    buf.append( qi.whereClause );
    try {
       ps = con.prepareStatement( buf.toString() );
       ps.clearParameters();
       int i = 0;
       for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();

    } finally {
      DBUtils.close(ps);	
    }
}

  public static class QueryInfo {
    String whereClause;
    List<? super Object> values = new LinkedList<Object>();
    public QueryInfo() {}
    public QueryInfo(String whereClause) {
       this.whereClause = whereClause;
    }
  }

  public static class UpdateQueryInfo {
     String query;
     List<? super Object> setValues = new LinkedList<Object>();
	 List<Integer> sqlTypes = new LinkedList<Integer>();
	 List<Boolean> nullSetList = new LinkedList<Boolean>();
	 List<? super Object> whereValues = new LinkedList<Object>();
	 
     public UpdateQueryInfo() {}
  }

/*+++    */
  // Enter your code here
/*+++    */
}//;
