package clinical.server.upload;

public class ScoreConditioner implements IConditioner {
  int type;
  public final static int INTEGER = 1;
  public final static int FLOAT = 2;
  public final static int BOOLEAN = 3;
  public final static int VARCHAR = 4;

  public ScoreConditioner(int type) {
    this.type = type;
  }

  public Object transform(Object rawData) throws ConditionException{
    // assert( rawData instanceof String);
    switch (type) {
      case INTEGER:
        return toInt( (String) rawData);
      case FLOAT:
        return toFloat( (String) rawData);
      case BOOLEAN:
        return toBoolean( (String) rawData);
      case VARCHAR:
      return (String) rawData;
      default:
        throw new ConditionException("Not a supported type!");
    }
  }


  protected Integer toInt(String rawData) throws ConditionException{
     Integer value = null;
     try {
        value = new Integer( Integer.parseInt(rawData) );
     } catch( NumberFormatException nfe) {
        throw new ConditionException( nfe.getMessage() );
     }
     return value;
  }

  protected Boolean toBoolean(String rawData) throws ConditionException{
    Boolean value = null;
    try {
      if (rawData.equals("1"))
         return new Boolean(true);
      else if (rawData.equals("0"))
         return new Boolean(false);
      value = new Boolean( Boolean.getBoolean(rawData) );
    } catch (NumberFormatException nfe) {
        throw new ConditionException( nfe.getMessage() );
    }
    return value;
  }


  protected Float toFloat(String rawData) throws ConditionException{
     Float value = null;
     try {
        value = new Float( Float.parseFloat(rawData) );
     } catch( NumberFormatException nfe) {
        throw new ConditionException( nfe.getMessage() );
     }
     return value;
  }


}