package clinical.server.upload;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.List;

import clinical.server.dao.oracle.AssessmentdataDAO;
import clinical.server.dao.oracle.AssessmentintegerDAO;
import clinical.server.dao.oracle.AssessmentvarcharDAO;
import clinical.server.vo.Assessmentdata;
import clinical.server.vo.Assessmentinteger;
import clinical.server.vo.Assessmentvarchar;

public class UploadValidator {

	public UploadValidator() {
	}

	int checkAssessmentDataValues(Connection con, String textValue)
			throws Exception {
		Assessmentdata criteria = new Assessmentdata();
		AssessmentdataDAO dao = new AssessmentdataDAO();
		criteria.setTextvalue(textValue);
		List<?> adList = dao.find(con, criteria);
		int count = 0;
		for (Iterator<?> it = adList.iterator(); it.hasNext();) {
			Assessmentdata ad = (Assessmentdata) it.next();
			System.out.println(ad);
			++count;
		}
		return count;
	}

	int checkAssessmentVarcharValues(Connection con, String asScoreName)
			throws Exception {
		int count = 0;
		Assessmentvarchar criteria = new Assessmentvarchar();
		AssessmentvarcharDAO dao = new AssessmentvarcharDAO();
		criteria.setScorename(asScoreName);
		List<?> valueList = dao.find(con, criteria);
		for (Iterator<?> it = valueList.iterator(); it.hasNext();) {
			Assessmentvarchar av = (Assessmentvarchar) it.next();
			System.out.println(av);
			++count;
		}

		return count;
	}

	int checkAssessmentIntValues(Connection con, String asScoreName)
			throws Exception {
		int count = 0;
		Assessmentinteger criteria = new Assessmentinteger();
		AssessmentintegerDAO dao = new AssessmentintegerDAO();
		criteria.setScorename(asScoreName);
		List<?> valueList = dao.find(con, criteria);
		for (Iterator<?> it = valueList.iterator(); it.hasNext();) {
			Assessmentinteger ai = (Assessmentinteger) it.next();
			System.out.println(ai);
			++count;
		}

		return count;
	}

	public void validateScoreValues(Connection con) throws Exception {
		int genderAsDataCount = checkAssessmentDataValues(con, "Gender");
		int genderAsVarcharCount = checkAssessmentVarcharValues(con, "Gender");
		int ageAsDataCount = checkAssessmentDataValues(con, "Age");
		int ageAsIntCount = checkAssessmentIntValues(con, "Age");
		int mmseAsDataCount = checkAssessmentDataValues(con, "MMSE Score");
		int mmseAsIntCount = checkAssessmentIntValues(con, "MMSE Score");

		System.out.println("genderAsDataCount=" + genderAsDataCount
				+ ",genderAsVarcharCount=" + genderAsVarcharCount);
		System.out.println("ageAsDataCount=" + ageAsDataCount
				+ ",ageAsIntCount=" + ageAsIntCount);

		System.out.println("mmseAsDataCount=" + mmseAsDataCount
				+ ",mmseAsIntCount=" + mmseAsIntCount);

	}

	public static void usage() {
		System.err
				.println("java clinical.server.UploadValidator <dbURL> <usr> <pwd>");
		System.err
				.println("\twhere dbURL has the following syntax jdbc:oracle:thin:@<host>:<port>:<sid>");
		System.exit(1);
	}

	public static void main(String[] args) {
		UploadValidator uv = new UploadValidator();
		if (args.length != 3)
			usage();

		String dbURL = args[0];
		String user = args[1];
		String pwd = args[2];

		Connection con = null;
		try {
			Class.forName("oracle.jdbc.driver.OracleDriver");
			con = DriverManager.getConnection(dbURL, user, pwd);
			uv.validateScoreValues(con);
		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (con != null)
				try {
					con.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}
}