package clinical.server.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PostgresUtils.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public final  class PostgresUtils {
  private PostgresUtils() {}
  
  public static Float toFloat(Object bean) {
	  if ( bean == null) {
		  return null;
	  }
	  if ( bean instanceof Double) {
		  return new Float( ( (Double) bean).floatValue());
	  } else {
		  throw new RuntimeException("Cannot convert bean to Float:" + bean.getClass());
	  }
  }
  
  public static Double toDouble(Float bean) {
	  if ( bean == null) {
		  return null;
	  }
	  return new Double( bean.doubleValue() );  
  }
  
  public static BigDecimal toBigDecimal(Object bean) {
	  if ( bean == null) {
		  return null;
	  }
	  if ( bean instanceof Double) {
		  return new BigDecimal(((Double) bean).doubleValue());
	  } else {
		  throw new RuntimeException("Cannot convert bean to BigDecimal:" + bean.getClass());
	  }
  }
  
  public static Double toDouble(BigDecimal bean) {
	  if ( bean == null) {
		  return null;
	  }
	  return new Double( bean.doubleValue() );  
  }
  
  public static Timestamp toTimestamp(Object bean) {
	  if ( bean == null) {
		  return null;
	  }
	  if ( bean instanceof Timestamp) {
		  return (Timestamp) bean;
	  } else {
		  throw new RuntimeException("Cannot convert bean to Timestamp:" + bean.getClass());
	  }
  }
}
