package clinical.test;

import java.util.ArrayList;
import java.util.List;

import clinical.utils.AFNIHeaderReader;
import clinical.utils.Field;
import clinical.utils.HeaderFields;
import clinical.web.vo.HeaderFieldType;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AFNIHeaderReaderTests.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class AFNIHeaderReaderTests extends TestCase {

	public AFNIHeaderReaderTests(String name) {
		super(name);
	}

	public void testTagFieldRead() throws Exception {
		String rootDir = "/Users/bozyurt/cbfbirn_data/sampledata/090819_vg_visual";
		rootDir = "/Users/bozyurt/cbfbirn_data/sampledata/090713_ds_stern";
		String headerFile = rootDir + "/P17408.7brik_e01+orig.HEAD";
		headerFile = rootDir + "/P18944.7brik_e02+orig.HEAD";
		headerFile = rootDir + "/CSFbrik+orig.HEAD";
		
		AFNIHeaderReader ahr = new AFNIHeaderReader(headerFile);
		ahr.readHeader();
		List<HeaderFieldType> hftList = new ArrayList<HeaderFieldType>(5);
		hftList.add(new HeaderFieldType("tag", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("timestamp", HeaderFieldType.STRING,"NOTE_DATE_001"));
		HeaderFields hf = ahr.extractFields(hftList);
		Field<Integer> tagField = hf.getIntField("tag");
		System.out.println(hf.getIntField("tag"));
		System.out.println(hf.getStringField("timestamp"));
		assertNotNull(tagField);
	}
	
	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new AFNIHeaderReaderTests("testTagFieldRead"));
		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}

}
