package clinical.test;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;

import junit.framework.TestSuite;

import clinical.cache.CacheUtils;
import clinical.server.dao.ExtendedtupleDAO;
import clinical.server.vo.Extendedtuple;
import clinical.server.vo.Tuplecolumns;
import clinical.server.vo.Tuplevarchar;
import clinical.test.framework.TestDataTemplateUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.IAnalysisResultService;
import clinical.web.ServiceFactory;
import clinical.web.common.query.AnalysisDDQueryBuilder;
import clinical.web.common.query.Operator;
import clinical.web.common.vo.AnalysisResultSummary;
import clinical.web.services.AnalysisResultServiceImpl;
import clinical.web.services.SecurityService;
import clinical.web.vo.AnalysisResultQueryInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisResultServiceTestsAuto.java,v 1.1 2008/09/04 00:31:58
 *          bozyurt Exp $
 */
public class AnalysisResultServiceAutoTest extends MyDBTestCase {
   boolean needsInit = false;
   boolean needsRestore = false;

   public AnalysisResultServiceAutoTest(String testName) throws IOException {
      super(testName, "test.properties", true);
      needsInit = testName.equals("testGetTupleColumnsForET");
      needsRestore = testName.equals("testAnalysisDDQueryWithFilter");

      setVerbose(false);
      // FIXME test
      // needsRestore = needsInit = false;
   }

   @Override
   protected void setUp() throws Exception {
      super.setUp();
      if (needsInit) {
         super.tableNames.clear();
         String stateFile = getProperty("freesurfer.state.file");
         System.out.println("state file:" + stateFile);
         File f = new File(stateFile);
         if (!f.exists()) {
            String templateFilename = f.getName();
            templateFilename = templateFilename.replaceFirst("\\.xml",
                  "_template.xml");
            File tf = new File(f.getParent(), templateFilename);
            TestDataTemplateUtils t = null;

            t = new TestDataTemplateUtils(this.mixin, tf
                  .getAbsolutePath());
            t.rewrite(stateFile);

         }

         List<String> tables = super.getEffectedTables(stateFile);
         List<String> nonPKtables = new ArrayList<String>(5);
         for (String tn : tables) {
            if (tn.equalsIgnoreCase("nc_analysisflow")
                  || tn.equalsIgnoreCase("nc_executedtransformflow")
                  || tn.equalsIgnoreCase("nc_transforminputdata")) {
               nonPKtables.add(tn.toUpperCase());
            }
            tableNames.add(tn.toUpperCase());
         }
         takeEffectedTablesSnapshot();
         try {
            prepareState(stateFile, nonPKtables);
         } catch (Exception x) {
            x.printStackTrace();
            throw x;
         }
      }
      SecurityService.getInstance(getDbPoolService(), getDbID(), super.mixin
            .getDbType());

   }

   @Override
   protected void tearDown() throws Exception {
      if (needsRestore) {
         super.tableNames.clear();
         String stateFile = getProperty("freesurfer.state.file");
         List<String> tables = super.getEffectedTables(stateFile);
         List<String> nonPKtables = new ArrayList<String>(5);
         for (String tn : tables) {
            if (tn.equalsIgnoreCase("nc_analysisflow")
                  || tn.equalsIgnoreCase("nc_executedtransformflow")
                  || tn.equalsIgnoreCase("nc_transforminputdata")) {
               nonPKtables.add(tn.toUpperCase());
            }
            tableNames.add(tn.toUpperCase());
         }
         restoreEffectedTables(nonPKtables);
      }
      super.tearDown();
   }

   public void testGetTupleColumnsForET() throws Exception {
      System.out.println("running test: " + getName());
      Connection con = null;
      AnalysisResultServiceImpl arsi = null;
      try {
         arsi = new AnalysisResultServiceImpl(getDbID());
         con = super.getPooledConnection();

         List<String> exTupleNames = new ArrayList<String>(1);
         exTupleNames.add("HID_TEST_FreeSurfer volume aseg.stats");
         List<Tuplecolumns> tcList = arsi.getTupleColumnsForET(con,
               exTupleNames);
         assertFalse(tcList.isEmpty());
         for (Tuplecolumns tc : tcList) {
            System.out.println(tc);
         }
         assertEquals(11, tcList.size());
      } finally {
         super.releasePooledConnection(con);
      }
   }

   public void testGetMeasurementGroupNamesForET() throws Exception {
      System.out.println("running test: " + getName());
      Connection con = null;
      AnalysisResultServiceImpl arsi = null;
      try {
         arsi = new AnalysisResultServiceImpl(getDbID());
         con = super.getPooledConnection();
         ExtendedtupleDAO etDAO = DAOFactory.createExtendedtupleDAO(getDbID());
         List<Integer> extTupleIDList = new ArrayList<Integer>(2);
         Extendedtuple cr = new Extendedtuple();
         cr.setName("HID_TEST_FreeSurfer volume aseg.stats");
         List<Extendedtuple> etList = etDAO.find(con, cr);
         assertFalse(etList.isEmpty());

         extTupleIDList.add(etList.get(0).getUniqueid().intValue());

         List<Tuplevarchar> tvList = arsi.getMeasurementGroupNamesForET(con,
               "anatomicalEntity", extTupleIDList);
         assertFalse(tvList.isEmpty());
         for (Tuplevarchar tv : tvList) {
            System.out.println(tv.getTextvalue());
         }
      } finally {
         releasePooledConnection(con);
      }
   }

   public void testAnalysisDDQueryBuilder() throws Exception {
      System.out.println("running test: " + getName());
      String json = "{mgQPIList: [{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Cerebral_Cortex', tupleName:'null',"
            + "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
            + "connector: 'NONE',operator: 1, rhs : '*'}\n"
            + ",{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Left-Amygdala',tupleName:'null',"
            + "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
            + "connector: 'AND',operator: 1, rhs : '*'}\n" + "]}";
      JSONObject js = new JSONObject(json);
      AnalysisResultQueryInfo arqi = AnalysisResultQueryInfo
            .initializeFromJSON(js);
      Operator root = arqi.prepareOpTree();
      System.out.println(root.toString());
      AnalysisDDQueryBuilder builder = new AnalysisDDQueryBuilder(
            ServiceFactory.getSQLDialect(getDbID()), null);

      builder.visit(root);
      String query = builder.getQuery();
      System.out.println(GenUtils.applyWordWrapping(query));

      IAnalysisResultService asr = ServiceFactory
            .getAnalysisResultService(getDbID());

      String siteID = CacheUtils.getDBID2SiteIDMap().get(mixin.getDbID());

      List<AnalysisResultSummary> arsList = asr.queryForAnalysisResults(
            getUi(), root, null, Constants.SEGMENT_SCOPE, siteID);
      for (AnalysisResultSummary ars : arsList) {
         System.out.println(ars);
      }
      assertFalse(arsList.isEmpty());
   }

   public void testAnalysisDDQueryWithFilter() throws Exception {
      System.out.println("running test: " + getName());
      String json = "{mgQPIList: [{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Right-Caudate',tupleName:'null',"
            + "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
            + "connector: 'NONE',operator: 2, rhs : '2000.0'}\n" // <
            + ",{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Right-Amygdala',tupleName:'null',"
            + "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
            + "connector: 'AND',operator: 3, rhs : '2000.0'}\n" + "]}"; // >
      JSONObject js = new JSONObject(json);
      AnalysisResultQueryInfo arqi = AnalysisResultQueryInfo
            .initializeFromJSON(js);
      Operator root = arqi.prepareOpTree();
      System.out.println(root.toString());
      AnalysisDDQueryBuilder builder = new AnalysisDDQueryBuilder(
            ServiceFactory.getSQLDialect(getDbID()), null);

      builder.visit(root);
      String query = builder.getQuery();
      System.out.println(GenUtils.applyWordWrapping(query));

      IAnalysisResultService asr = ServiceFactory
            .getAnalysisResultService(getDbID());

      List<AnalysisResultSummary> arsList = asr.queryForAnalysisResults(
            getUi(), root, null, Constants.SEGMENT_SCOPE, "0008");
      for (AnalysisResultSummary ars : arsList) {
         System.out.println(ars);
      }
      assertFalse(arsList.isEmpty());

   }

   public static TestSuite suite() throws IOException {
      TestSuite suite = new TestSuite();
      suite.addTest(new AnalysisResultServiceAutoTest(
            "testGetTupleColumnsForET"));
      suite.addTest(new AnalysisResultServiceAutoTest(
            "testGetMeasurementGroupNamesForET"));
      suite.addTest(new AnalysisResultServiceAutoTest(
            "testAnalysisDDQueryBuilder"));
      suite.addTest(new AnalysisResultServiceAutoTest(
            "testAnalysisDDQueryWithFilter"));
      return suite;
   }

   public static void main(String[] args) throws IOException {
      junit.textui.TestRunner.run(suite());
   }
}
