package clinical.test;

import java.io.IOException;
import java.util.List;

import junit.framework.TestSuite;

import org.dbunit.dataset.IDataSet;

import clinical.server.vo.Person;
import clinical.web.Constants;
import clinical.web.IExperimentManagement;
import clinical.web.ServiceFactory;
import clinical.web.vo.ExperimentInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentManagementTest.java,v 1.5 2007/11/27 02:16:34 bozyurt
 *          Exp $
 */
public class ExperimentManagementTest extends MyDBTestCase {
	private final static boolean SINGLE_TEST_MODE = true; 

	public ExperimentManagementTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile, true);
	}

	@Override
	protected IDataSet getDataSet() throws Exception {
		return null;
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		
		tableNames.add(Constants.EXPERIMENT_DB_TABLE);
        takeEffectedTablesSnapshot();		
	}

	@Override
	protected void tearDown() throws Exception {
		if ( SINGLE_TEST_MODE) {
			restoreEffectedTables();
		}
		super.tearDown();
	}

	public void testAddExperiment() throws Exception {
		IExperimentManagement iem = ServiceFactory
				.getExperimentManagement(getDbID());
		List<Person> contactList = iem.getAllContactPersons(getUi());
		assertTrue("Expecting nonempty contact list!", !contactList.isEmpty());
		Person cp = contactList.get(0);
		ExperimentInfo expInfo = new ExperimentInfo();
		expInfo.setName("My Test Experiment");
		expInfo.setContactPersonValue(cp.getUniqueid().toString());

		iem.addExperiment(getUi(), expInfo);
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new ExperimentManagementTest("testAddExperiment",
				"test.properties"));

		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}