package clinical.test;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import clinical.server.vo.Rawdata;
import clinical.web.IAppConfigService;
import clinical.web.ImageHandler;
import clinical.web.ServiceFactory;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ImageHandlerTest.java 365 2011-05-05 20:04:18Z bozyurt $
 */

public class ImageHandlerTest extends MyTestCase {
	Connection con;
	// TODO hardcoded
	protected String dbID = "ucsd_fbirn";

	public ImageHandlerTest(String testName, String propsFile) throws IOException {
		super(testName, propsFile);
	}

	protected void setUp() throws Exception {
		Class.forName("oracle.jdbc.driver.OracleDriver");

		String dbURL = getProperty("mbirn.dburl");
		String user = getProperty("mbirn.user");
		String pwd = getProperty("mbirn.pwd");
		con = DriverManager.getConnection(dbURL, user, pwd);
		System.out.println("Got connection");

	}

	protected void tearDown() throws Exception {
		if (con != null) {
			System.out.println("closing connection.");
			try {
				con.close();
			} catch (Exception x) {
			}
		}
	}

	public void testRawDataForSubject() throws Exception {
		ImageHandler ih = ServiceFactory.getImageHandlerService();

		BigDecimal visitID = new BigDecimal("1");
		BigDecimal expID = new BigDecimal("7");
		String subjectID = "UCSD93356348";
		BigDecimal segmentID = new BigDecimal("1");
		List<Rawdata> rawDatas = ih.getRawDataForSubject(this.dbID, con,
				subjectID, visitID, expID, segmentID);
		assertTrue(!rawDatas.isEmpty());
		for (Object element : rawDatas) {
			Rawdata item = (Rawdata) element;
			System.out.println(item.toString());
		}
	}

	public void testRetrieveMRISeries() throws Exception {
		ImageHandler ih = ServiceFactory.getImageHandlerService();
		BigDecimal visitID = new BigDecimal("1");
		BigDecimal expID = new BigDecimal("7");
		String subjectID = "UCSD93356348";
		BigDecimal segmentID = new BigDecimal("1");
		List<Rawdata> rawDatas = ih.getRawDataForSubject(this.dbID, con, subjectID,
				visitID, expID, segmentID);
		assertTrue(!rawDatas.isEmpty());

		Rawdata rd = (Rawdata) rawDatas.get(0);

		String cacheRoot = getProperty("mbirn.cacheroot");
		// Properties appProps = GenUtils.loadProperties("clinical.properties");
		IAppConfigService configService = ServiceFactory.getAppConfigService();

		String tarFile = ih.retrieveMRISeriesForSubject(cacheRoot, rd
				.getDatauri(), configService);

		assertNotNull(tarFile);
		System.out.println("tarFile:" + tarFile);
	}

	public void testCacheCleanup() throws Exception {
		ImageHandler ih = ServiceFactory.getImageHandlerService();
		String cacheRoot = getProperty("mbirn.cacheroot");

		IAppConfigService configService = ServiceFactory.getAppConfigService();
		//Properties appProps = GenUtils.loadProperties("clinical.properties");
		
		ih.doCacheCleanup(cacheRoot, configService, 86400, -1, false);
		// Executor ex = new Executor("c:\\cygwin\\bin\\perl.exe",true);
		// ex.execute("c:\\cygwin\\home\\bozyurt\\dev\\java\\clinical\\bin\\cleanup.pl");

	}

	public static Test suite() throws IOException {
		TestSuite suite = new TestSuite();
		// suite.addTest(new ImageHandlerTest("testRawDataForSubject",
		// "test.properties"));
		// suite.addTest(new ImageHandlerTest("testRetrieveMRISeries",
		// "test.properties"));
		suite.addTest(new ImageHandlerTest("testCacheCleanup",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}
