package clinical.test;

/**
 * @author I. Burak Ozyurt
 * @version $Id: QueryRequestInfo.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class QueryRequestInfo {
	String name;
	String assessmentName;
	String scoreName;
	String brainRegionName;
	RelQueryRequest relQueryRequest;
	BetweenQueryRequest betweenQueryRequest;

	QueryRequestInfo previous;
	QueryRequestInfo next;
	int combinator;
	public static final int NONE = 0;
	public static final int AND = 1;
	public static final int OR = 2;

	public QueryRequestInfo() {
		combinator = NONE;
	}

	// ---------------------- setters --------------
	public void setName(String newName) {
		this.name = newName;
	}

	public void setAssessmentName(String newAssessmentName) {
		this.assessmentName = newAssessmentName;
	}

	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setBrainRegionName(String newBrainRegionName) {
		this.brainRegionName = newBrainRegionName;
	}

	public void setRelQueryRequest(RelQueryRequest newRelQueryRequest) {
		this.relQueryRequest = newRelQueryRequest;
	}

	public void setBetweenQueryRequest(
			BetweenQueryRequest newBetweenQueryRequest) {
		this.betweenQueryRequest = newBetweenQueryRequest;
	}

	public void setPrevious(QueryRequestInfo newPrevious) {
		this.previous = newPrevious;
	}

	public void setNext(QueryRequestInfo newNext) {
		this.next = newNext;
	}

	public void setCombinator(int newCombinator) {
		this.combinator = newCombinator;
	}

	// ---------------------- getters --------------
	public String getName() {
		return this.name;
	}

	public String getAssessmentName() {
		return this.assessmentName;
	}

	public String getScoreName() {
		return this.scoreName;
	}

	public String getBrainRegionName() {
		return this.brainRegionName;
	}

	public RelQueryRequest getRelQueryRequest() {
		return this.relQueryRequest;
	}

	public BetweenQueryRequest getBetweenQueryRequest() {
		return this.betweenQueryRequest;
	}

	public QueryRequestInfo getPrevious() {
		return this.previous;
	}

	public QueryRequestInfo getNext() {
		return this.next;
	}

	public int getCombinator() {
		return this.combinator;
	}

	public static class RelQueryRequest {
		String rhs;
		int relOp;

		public RelQueryRequest(int relOp, String rhs) {
			this.rhs = rhs;
			this.relOp = relOp;
		}

		public String getRhs() {
			return this.rhs;
		}

		public int getRelOp() {
			return this.relOp;
		}
	}

	public static class BetweenQueryRequest {
		String lowBound;
		String uppBound;

		public BetweenQueryRequest(String lowBound, String uppBound) {
			this.lowBound = lowBound;
			this.uppBound = uppBound;
		}

		public String getLowBound() {
			return this.lowBound;
		}

		public String getUppBound() {
			return this.uppBound;
		}
	}
}