package clinical.test;

import java.util.LinkedList;
import java.util.List;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ScoreHierarchyTests.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class ScoreHierarchyTests extends TestCase {
	AssessmentSelectionInfo asi;

	public ScoreHierarchyTests(String name) {
		super(name);
	}

	protected void setUp() {
		asi = new AssessmentSelectionInfo();
		asi.setName("Test Assessment");
		List<AsScoreInfo> topLevelScores = new LinkedList<AsScoreInfo>();
		AsScoreInfo tl1 = prepareScoreInfo("top level 1");
		AsScoreInfo tl2 = prepareScoreInfo("top level 2");
		topLevelScores.add(tl1);
		topLevelScores.add(tl2);

		AsScoreInfo level1_1 = prepareScoreInfo("level 1 - score 1");
		AsScoreInfo level1_2 = prepareScoreInfo("level 1 - score 2");
		AsScoreInfo level1_3 = prepareScoreInfo("level 1 - score 3");

		AsScoreInfo level2_1 = prepareScoreInfo("level 2 - score 1");
		AsScoreInfo level2_2 = prepareScoreInfo("level 2 - score 2");

		AsScoreInfo level3_1 = prepareScoreInfo("level 3 - score 1");
		AsScoreInfo level3_2 = prepareScoreInfo("level 3 - score 2");

		tl1.addChild(level1_1);
		tl1.addChild(level1_2);
		tl2.addChild(level1_3);

		level1_1.addChild(level2_1);
		level1_1.addChild(level2_2);

		level2_2.addChild(level3_1);
		level2_2.addChild(level3_2);

		asi.addScore(tl1);
		asi.addScore(tl2);

		asi.setTopLevelScores(topLevelScores);
	}

	protected AsScoreInfo prepareScoreInfo(String name) {
		AsScoreInfo si = new AsScoreInfo(null);
		si.setName(name);
		return si;
	}

	public void testLevelCount() throws Exception {
		AsScoreInfo tl1 = (AsScoreInfo) asi.getTopLevelScores().get(0);

		int levelCount = asi.getMaxTreeLevelCount(tl1);
		System.out.println("levelCount = " + levelCount);
		assertEquals(levelCount, 3);
	}

	public void testPreOrderTraversal() throws Exception {
		AsScoreInfo tl1 = (AsScoreInfo) asi.getTopLevelScores().get(0);
		List<AsScoreInfo> orderList = asi.getPreOrderTraverseList(tl1);
		for (Object element : orderList) {
			AsScoreInfo si = (AsScoreInfo) element;
			System.out.println(si.toString());
		}
		assertEquals(orderList.size(), 6);
		AsScoreInfo lastNode = (AsScoreInfo) orderList
				.get(orderList.size() - 1);
		assertEquals(lastNode.getName(), "level 1 - score 2");
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new ScoreHierarchyTests("testLevelCount"));
		suite.addTest(new ScoreHierarchyTests("testPreOrderTraversal"));
		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}

}