package clinical.test;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.vo.Animalspecies;
import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.web.Constants;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.query.SearchCriteria;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.SearchPredicateList;
import clinical.web.exception.BaseException;
import clinical.web.vo.CollectionEquipment;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: SubjectVisitManagementTest.java,v 1.9 2005/09/09 01:52:20
 *          bozyurt Exp $
 */
public class SubjectVisitManagementTest extends MyDBTestCase {
	protected String owner;
	protected String modUser;
	private final static boolean SS_MODE = false;
	private Log log = LogFactory.getLog("SubjectVisitManagementTest");

	public SubjectVisitManagementTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile, true);
	}

	protected void setUp() throws Exception {
		super.setUp();
		tableNames.add(Constants.EXPERIMENT_DB_TABLE);
		tableNames.add(Constants.HUMANSUBJECT_DB_TABLE);
		tableNames.add(Constants.COMPONENT_DB_TABLE);
		tableNames.add(Constants.SEGMENT_DB_TABLE);

		owner = getProperty("fbirn.owner");
		modUser = getProperty("fbirn.moduser");
		if (SS_MODE) {
			prepareSnapshotFile();
		}

		takeEffectedTablesSnapshot();
	}

	@Override
	protected void tearDown() throws Exception {
		if (SS_MODE) {
			prepareFullSetDiffSetFile();
		}

		restoreEffectedTables();

		super.tearDown();
	}

	public void testAddSubject() throws Exception {
		log.debug("testing adding a new subject");
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		String subjectID = getProperty("subject.subjectID");
		assertTrue(
				"subject.subjectID must be defined in the test properties file",
				subjectID != null);
		Subject subject = new Subject(subjectID);
		subject.setExtensionName("humanSubject");
		Animalspecies as = findAnimalSpecies();
		assertNotNull("No animalspecies record in DB", as);
		subject.setAnimalSpeciesID(Integer
				.parseInt(as.getUniqueid().toString()));

		svm.addSubject(getUi(), subject);
	}

	protected Animalspecies findAnimalSpecies() throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(getDbID());
		List<Animalspecies> asList = dbCache.getAnimalSpecies(getUi(), false);
		String animalSpeciesName = getProperty("animalspecies.name");
		for (Animalspecies as : asList) {
			if (as.getName().equals(animalSpeciesName)) {
				return as;
			}
		}
		return null;
	}

	protected Experiment findExperiment() throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(getDbID());
		List<Experiment> expList = dbCache.getExperiments(getUi(), true);
		String expName = getProperty("visit.experimentName");
		for (Experiment exp : expList) {
			if (exp.getName().equals(expName)) {
				return exp;
			}
		}
		return null;
	}

	public void testFindSubjects() throws Exception {
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());

		SearchPredicateList spList = new SearchPredicateList();
		//SearchPredicate sp = new SearchPredicate("subjectid", "UCSD1",
		//		SearchPredicate.STARTS_WITH, SearchPredicate.STRING);
		// spList.addSearchPredicate(sp, SearchPredicateList.NONE);

		spList.addSearchPredicate(new SearchPredicate("extensionname",
				"humanSubject", SearchPredicate.EQUAL, SearchPredicate.STRING),
				SearchPredicateList.NONE);

		List<Humansubject> subjects = svm.getMatchingSubjects(getUi(),
				new SearchCriteria(spList));
		for (Humansubject subject : subjects) {
			System.out.println(subject);
		}
	}

	public void testAddVisitForSubject() throws Exception {
		// prepare state
		DBStateManHelper.addExperiment( getUi(), getDbID());
		testAddSubject();

		// test starts
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		Visit visit = new Visit();
		visit.setDescription(getProperty("visit.description"));

		visit.setSubjectID(getProperty("visit.subjectID"));
		Experiment exp = findExperiment();
        assertNotNull(exp);
		int experimentID = Integer.parseInt(exp.getUniqueid().toString());
		visit.setExperimentID(experimentID);
		visit.setComponentID(1);
		visit.setVisitType(getProperty("visit.visitType"));
		visit.setTimeStamp(new Timestamp(System.currentTimeMillis()));

		VisitSegment vs = new VisitSegment();
		vs.setDescription(getProperty("visit.description"));
		// segment");
		CollectionEquipment ce = new CollectionEquipment();
		ce.setMake("GENERAL ELECTRIC");
		vs.setEquipment(ce);
		vs.setExperimentID(experimentID);
		// protocol info
		vs.setProtocolID(getProperty("visit.segment.protocolID"));
		vs.setProtocolVersion(Integer
				.parseInt(getProperty("visit.segment.protocolVersion")));
		vs.setSegmentID(1);
		vs.setSubjectID(getProperty("visit.subjectID"));
		vs.setTimeStamp(new Timestamp(System.currentTimeMillis()));

		visit.addVisitSegment(vs);

		svm.addVisitForSubject(getUi(), visit);
	}

	public void testDeleteVisitForSubject() throws Exception {
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		Visit visit = new Visit();
		visit.setSubjectID(getProperty("visit.subjectID"));
		int experimentID = Integer.parseInt(getProperty("visit.experimentID"));
		visit.setExperimentID(experimentID);
		visit.setComponentID(1);

		svm.deleteVisitForSubject(getUi(), visit);
	}

	public void testRemoveSubject() throws Exception {
		log.debug("testing removing an existing subject new subject");
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		String subjectID = getProperty("subject.subjectID");
		assertTrue(
				"subject.subjectID must be defined in the test properties file",
				subjectID != null);

		Subject subject = new Subject(subjectID);
		Animalspecies as = findAnimalSpecies();
		assertNotNull("No animalspecies record in DB", as);
		subject.setAnimalSpeciesID(Integer
				.parseInt(as.getUniqueid().toString()));

		svm.deleteSubject(getUi(), subject);
	}

	public void testUpdateVisitSegment() throws Exception {
		// prepare state
		testAddVisitForSubject();


		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		VisitSegment vs = new VisitSegment();
		vs.setProtocolVersion(Integer
				.parseInt(getProperty("visit.segment.protocolVersion")));
		vs.setDescription(getProperty("visit.segment.new_description"));

		Experiment exp = findExperiment();
        assertNotNull(exp);
		int experimentID = Integer.parseInt(exp.getUniqueid().toString());

		vs.setExperimentID(experimentID);
		vs.setVisitID(1);
		vs.setSegmentID(1);
		vs.setSubjectID(getProperty("visit.subjectID"));
		svm.updateVisitSegmentForSubject(getUi(), vs);
	}

	public void testGetExperimentsForSubject() throws Exception {
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		String subjectID = getProperty("subject.subjectID");
		List<Experiment> experiments = svm.getExperimentsForSubject(getUi(),
				subjectID);

		assertTrue(experiments.size() == 1);
	}

	public void testGetAllVisitsForSubject() throws Exception {
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		String subjectID = getProperty("subject.subjectID");

		List<Visit> visits = svm.getAllVisitsForSubject(getUi(), subjectID);
		for (Visit visit : visits) {
			System.out.println(visit.toString());
		}
	}

	public void testDeleteAssessmentFromASegment() throws Exception {
		ISubjectVisitManagement svm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		int expID = 52550; // Test2
		String subjectID = "009028909284";
		int visitID = 1;
		int segmentID = 1;
		int asID = 53231; // NAART
		svm.deleteAssessmentFromSegment(getUi(), subjectID, visitID, segmentID,
				expID, asID);
	}

	public static TestSuite suite() throws Throwable {
		TestSuite suite = new TestSuite();
		// suite.addTest(new SubjectVisitManagementTest(
		// "testDeleteAssessmentFromASegment", "test.properties"));

		// suite.addTest( new
		// SubjectVisitManagementTest("testGetAllVisitsForSubject",
		// "test.properties") );

		suite.addTest( new SubjectVisitManagementTest("testAddSubject", "test.properties") );
		suite.addTest( new SubjectVisitManagementTest("testRemoveSubject","test.properties") );
		suite.addTest(new SubjectVisitManagementTest("testAddVisitForSubject", "test.properties"));
		suite.addTest( new SubjectVisitManagementTest("testUpdateVisitSegment","test.properties") );


		// suite.addTest( new SubjectVisitManagementTest("testFindSubjects", "test.properties") );

	    // suite.addTest( new
		// SubjectVisitManagementTest("testDeleteVisitForSubject",
		// "test.properties") );


		return suite;
	}

	public static void main(String[] args) throws Throwable {
		junit.textui.TestRunner.run(suite());
	}

}
