package clinical.test.cbf;

import java.util.Map;

import clinical.server.vo.Databaseuser;
import clinical.web.ConnectionSupportMixin;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.User;
import clinical.web.services.SecurityService;
import clinical.web.services.SimpleSecurityService;
import junit.framework.TestCase;

public class BaseTestCase extends TestCase {
	protected ConnectionSupportMixin csm;

	public BaseTestCase(String testName) {
		super(testName);
	}

	@Override
	protected void setUp() throws Exception {
		csm = new ConnectionSupportMixin("users.xml");
		csm.startup();

		SecurityService ss = SecurityService.getInstance(
				csm.getDbPoolService(), csm.getDbID(), csm.getDbType());
		ss.startup();
	}
	
	protected void tearDown() throws Exception {
		shutdown();
	};
	
	
	protected Databaseuser getDatabaseUser(UserInfo ui, String userClass)
			throws Exception {
		ISecurityService securityService = SimpleSecurityService.getInstance();
		IDBCache dbCache = ServiceFactory.getDBCache(csm.getDbID());

		Map<String, User> userMap = securityService.getAllUsers(csm.getDbID());
		User u = (User) userMap.get(ui.getName());

		Databaseuser databaseUser = dbCache.getDatabaseUser(ui, u.getDbUser()
				.getName(), userClass);
		if (databaseUser == null) {
			System.err.println("databaseUser was null (from dbCache)");
		}
		return databaseUser;
	}

	public void shutdown() throws Exception {
		if (csm != null) {
			csm.shutdown();
		}
	}
}
