package clinical.test.cbf;

import java.io.IOException;
import java.sql.Connection;
import java.util.List;

import junit.framework.TestSuite;
import clinical.server.vo.Experiment;
import clinical.test.MyTestCase;
import clinical.web.ICBFProcReportQueryService;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.common.vo.CBFProcessReportRecListWrapper;
import clinical.web.services.SecurityService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFProcessReportTests.java 514 2012-01-19 02:00:09Z bozyurt $
 */
public class CBFProcessReportTests extends MyTestCase {

	public CBFProcessReportTests(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile, true);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		SecurityService ss = SecurityService.getInstance(getDbPoolService(),
				getDbID(), super.mixin.getDbType());
		ss.startup();
	}

	public void testGetCBFProcessRecords() throws Exception {
		ICBFProcReportQueryService icrqs = ServiceFactory
				.getCBFProcReportQueryService(getDbID());

		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(getDbID());
		List<Experiment> allVisibleExperiments = null;
		Connection con = null;
		try {
			allVisibleExperiments = isvm.getAllVisibleExperiments(getUi(),
					getConnection());
		} finally {
			releaseConnection(con);
		}

		CBFProcessReportRecListWrapper wrapper = icrqs.getCBFProcessRecords(
				getUi(), allVisibleExperiments);
		for (CBFProcessReportRec rec : wrapper.getRecords()) {
			System.out.println(rec);
		}
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new CBFProcessReportTests("testGetCBFProcessRecords",
				"prod_test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}
