package clinical.test.cbf;

import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import clinical.server.vo.Humansubject;
import clinical.web.ConnectionSupportMixin;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.services.IDataArchivalService;
import clinical.web.services.SecurityService;
import clinical.web.vo.Visit;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DataArchivalServiceTests.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class DataArchivalServiceTests {
	protected ConnectionSupportMixin csm;

	@Before
	public void setUp() throws Exception {
		csm = new ConnectionSupportMixin("users.xml");
		csm.startup();
		SecurityService ss = SecurityService.getInstance(
				csm.getDbPoolService(), csm.getDbID(), csm.getDbType());
		ss.startup();
	}

	@After
	public void tearDown() throws Exception {
		if (csm != null) {
			csm.shutdown();
		}
	}

	@Test
	public void testArchiveSubject() throws Exception {
		UserInfo ui = csm.getUi();
		String dbID = csm.getDbID();

		IDataArchivalService das = ServiceFactory.getDataArchivalService(dbID);

		ISubjectVisitManagement svms = ServiceFactory
				.getSubjectVisitManagement(dbID);
		List<Humansubject> allSubjects = svms.getAllVisibleSubjects(ui);
		for (Humansubject hs : allSubjects) {
			// System.out.println(hs);
			List<Visit> visitsForSubject = svms.getAllVisitsForSubject(ui, hs
					.getSubjectid());
			if (!visitsForSubject.isEmpty()) {
				Visit visit = visitsForSubject.get(0);
				System.out.println(visit);

				// das.archiveVisit(ui, visit.getSubjectID(), visit
				// 		.getExperimentID(), visit.getComponentID());
				
				das.archiveSubject(ui, visit.getSubjectID(), visit.getExperimentID());
				break;
			}
		}
	}

	public static void main(String[] args) {
		org.junit.runner.JUnitCore
				.main("clinical.test.cbf.DataArchivalServiceTests");
	}
}
