package clinical.test.cbf;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestSuite;

import clinical.server.dao.JobProvParamTypeDAO;
import clinical.server.vo.JobProvParamType;
import clinical.utils.GenUtils;
import clinical.web.DAOFactory;
import clinical.web.common.query.Operator;
import clinical.web.common.query.ProvenanceQueryBuilder;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.UnaryOperator;
import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamInfo;

public class ProvenanceQueryTests extends BaseTestCase {

	public ProvenanceQueryTests(String testName) {
		super(testName);
	}

	protected Operator buildOpTree(List<JobProvParamType> provParamTypeList) {
		// JobProvParamType autoPT = findByName(provParamTypeList, "automated");

		JobProvenanceParamInfo pi = new JobProvenanceParamInfo("automated",
				"yes");
		UnaryOperator lhs = new UnaryOperator(new SearchPredicate(pi, "*",
				SearchPredicate.EQUAL, SearchPredicate.STRING), Operator.NONE);
		return lhs;
	}

	public static JobProvParamType findByName(
			List<JobProvParamType> provParamTypeList, String name) {
		for (JobProvParamType t : provParamTypeList) {
			if (t.getName().equals(name)) {
				return t;
			}
		}
		return null;
	}

	List<JobProvParamType> getProvParamTypeList(Connection con)
			throws Exception {
		JobProvParamTypeDAO dao = DAOFactory.createJobProvParamTypeDAO(csm
				.getDbID());
		return dao.find(con, new JobProvParamType());
	}

	public void testQuery() throws Exception {
		Connection con = null;
		try {
			con = csm.getConnection();
			List<JobProvParamType> provParamTypeList = getProvParamTypeList(con);

			List<Integer> experimentIDs = new ArrayList<Integer>(0);

			ProvenanceQueryBuilder pqb = new ProvenanceQueryBuilder(
					csm.getSqlDialect(),  experimentIDs);

			Operator op = buildOpTree(provParamTypeList);
			pqb.visit(op);
			String query = pqb.getQuery();

			System.out.println(GenUtils.applyWordWrapping(query));

		} finally {
			csm.releaseConnection(con);
		}
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
		suite.addTest(new ProvenanceQueryTests("testQuery"));
		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
