package clinical.test.cbf;

import java.io.IOException;
import java.util.Properties;

import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

import clinical.utils.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class UploadCommTests extends TestCase {
	Properties props;
	String targetURL;
	String user;
	String pwd;

	public UploadCommTests(String testName) throws IOException {
		super(testName);
		props = GenUtils.loadProperties("prod_test.properties");
	}

	@Override
	protected void setUp() throws Exception {
		targetURL = props.getProperty("uct.targetURL");
		user = props.getProperty("uct.user");
		pwd = props.getProperty("uct.pwd");
	}

	public void testCreateAndEnrollSubject() throws Exception {
		PostMethod postMethod = new PostMethod(targetURL);
		postMethod.addParameter(new NameValuePair("action",
				"createAndEnrollSubject"));
		postMethod.addParameter(new NameValuePair("user", user));
		postMethod.addParameter(new NameValuePair("pwd", pwd));

		postMethod.addParameter(new NameValuePair("expName",
				"FBIRNSubject2007TW__0051_uci"));
		postMethod.addParameter(new NameValuePair("subjectID", "000951011688"));
		postMethod.addParameter(new NameValuePair("birthDate", "01/01/1954"));
		postMethod.addParameter(new NameValuePair("gender", "M"));
		postMethod.addParameter(new NameValuePair("diagnosis",
				"traveling schizophrenic"));

		try {
			HttpClient client = new HttpClient();
			client.getHttpConnectionManager().getParams().setConnectionTimeout(
					5000);
			int status = client.executeMethod(postMethod);
			// assertEquals(status, HttpStatus.SC_OK);
			if (status == HttpStatus.SC_OK) {
				String jsonStr = postMethod.getResponseBodyAsString();
				if (jsonStr != null && jsonStr.trim().length() > 1) {
					System.out.println(jsonStr);
				}

			} else {
				fail("problem in authenticating the user: " + user
						+ "\nHTTP Status: " + status);
			}
		} finally {
			postMethod.releaseConnection();
		}
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
		suite.addTest(new UploadCommTests("testCreateAndEnrollSubject"));
		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
