package clinical.test.framework;

import java.sql.SQLException;
import java.util.BitSet;

import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.operation.OperationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RowOperation {
	private final Logger logger = LoggerFactory.getLogger(RowOperation.class);

	protected IPreparedBatchStatement _statement;
	protected OperationData _operationData;
	protected BitSet _ignoreMapping;

	/**
	 * Execute this operation on the specified table row.
	 *
	 * @return <code>true</code> if operation have been executed on the row.
	 */
	public boolean execute(ITable table, int row) throws DataSetException,
			SQLException {
		if (logger.isDebugEnabled())
			logger.debug("execute(table=" + table + ", row=" + row
					+ ") - start");

		Column[] columns = _operationData.getColumns();
		for (int i = 0; i < columns.length; i++) {
			// Bind value only if not in ignore mapping
			if (_ignoreMapping == null || !_ignoreMapping.get(i)) {
				Object value = table.getValue(row, columns[i].getColumnName());
				_statement.addValue(value, columns[i].getDataType());
			}
		}
		_statement.addBatch();
		int result = _statement.executeBatch();
		_statement.clearBatch();

		return result == 1;
	}

	/**
	 * Cleanup this operation state.
	 */
	public void close() throws SQLException {
		logger.debug("close() - start");

		if (_statement != null) {
			_statement.close();
		}
	}
}