package clinical.test.scheduler;

import clinical.web.common.UserInfo;
import clinical.web.scheduler.JobException;

public class AutoCBFProcessingJobMock extends CBFProcessingJobMock {

	public AutoCBFProcessingJobMock(String id, UserInfo ui, String description,
			String dbID) {
		super(id, ui, description, dbID);
	}
	
	@Override
	public void execute(int stageId) throws JobException {
		double maxTime = 25;
		long start = System.currentTimeMillis();
		int count = 1;
		while (true) {
			synchronized (this) {
				try {
					this.wait(2000);
				} catch (InterruptedException e) {
				}
			}
			if (isCanceled()) {
				break;
			}
			sendMessage("cbf proc ( " + stageId + ") " + count);
			long now = System.currentTimeMillis();

			if ((now - start) / 1000.0 > maxTime) {
				break;
			}
			count++;
		}
		System.out.println("*** Job " + id + " is finished.");
	}
	
	@Override
	public int getNumberOfStages() {
	    return 1;
	}

}
