package clinical.test.scheduler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import clinical.web.common.UserInfo;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.IJobEventListener;
import clinical.web.scheduler.IJobFactory;
import clinical.web.scheduler.JobEvent;
import clinical.web.scheduler.JobException;
import clinical.web.scheduler.JobRecord;
import clinical.web.scheduler.JobVisitContext;
import clinical.web.scheduler.remote.WFESLocation;

public class CBFProcessingJobMock implements IJob {
	protected boolean canceled = false;
	protected String id;
	protected UserInfo ui;
	protected String description;
	protected String dbID;
	IJobFactory jobFactory;
	protected List<IJobEventListener> listeners = new ArrayList<IJobEventListener>(
			1);
	protected String status;

	public CBFProcessingJobMock(String id, UserInfo ui, String description,
			String dbID) {
		this.id = id;
		this.ui = ui;
		this.description = description;
		this.dbID = dbID;
		this.jobFactory = new JobFactory(dbID);
	}

	@Override
	public void execute(int stageId) throws JobException {
		long start = System.currentTimeMillis();
		double stage1Time = 20;
		double stage2Time = 5;

		double maxTime = (stageId == 1) ? stage1Time : stage2Time;

		int count = 1;
		while (true) {
			synchronized (this) {
				try {
					this.wait(2000);
				} catch (InterruptedException e) {
				}
			}
			if (isCanceled()) {
				// TODO do cleanup
				break;
			}
			sendMessage("cbf proc ( " + stageId + ") " + count);
			long now = System.currentTimeMillis();

			if ((now - start) / 1000.0 > maxTime) {
				break;
			}
			count++;
		}

	}

	@Override
	public void addJobEventListener(IJobEventListener listener) {
		listeners.add(listener);
	}

	@Override
	public synchronized void cancel() {
		canceled = true;
	}

	@Override
	public String getContextAsJSON() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getDbID() {
		return this.dbID;
	}

	@Override
	public String getDescription() {
		return this.description;
	}

	@Override
	public int getDurationType() {
		return LONG;
	}

	@Override
	public String getID() {
		return this.id;
	}

	@Override
	public List<JobVisitContext> getJobVisitContextList() {
		return new ArrayList<JobVisitContext>(0);
	}

	@Override
	public int getNumberOfStages() {
		return 2;
	}

	@Override
	public String[] getResultsFiles() {
		return new String[0];
	}

	@Override
	public String getType() {
		return "CBF Processing Workflow";
	}

	@Override
	public String getUser() {
		return ui.getPerceivedName();
	}

	@Override
	public UserInfo getUserInfo() {
		return this.ui;
	}

	@Override
	public synchronized boolean isCanceled() {
		return canceled;
	}

	@Override
	public void saveResults(File file) throws JobException {
		// no op
	}

	@Override
	public void shutdown() {
		// no op
	}

	@Override
	public IJobFactory getJobFactory() {
		return jobFactory;
	}

	//  

	protected void sendMessage(String msg) {
		System.out.println("MocJob: " + msg);
		JobEvent event = new JobEvent(this, msg);
		// assumption only JobScheduler listens for events and does not remove
		// itself as a listener later
		for (IJobEventListener listener : listeners) {
			listener.statusChanged(event);
		}
	}

	public static class JobFactory implements IJobFactory {
		String dbID = null;

		public JobFactory(String dbID) {
			this.dbID = dbID;
		}
		
		@Override
		public IJob create(JobRecord jr) throws JobException {
			if (jr == null) {
				return null;
			}
			UserInfo jobUI = new UserInfo(jr.getUser(), null, null);
			CBFProcessingJobMock job = new CBFProcessingJobMock(jr.getJobID(),
					jobUI, jr.getDescription(), dbID);
			return job;
		}
	}
	
	@Override
	public synchronized String getStatus() {
		return status;
	}

	@Override
	public synchronized void setStatus(String status) {
		this.status = status;
	}
	
	@Override
	public void cleanup() {
		// no op
	}
	
	@Override
	public boolean setWFESLocation(WFESLocation location) {
		return false;
	}
}
