package clinical.tools.dbadmin;

import java.util.Map;

import clinical.server.vo.Databaseuser;
import clinical.web.ConnectionSupportMixin;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.User;
import clinical.web.services.SimpleSecurityService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public abstract class AbstractAdmin {
	protected ConnectionSupportMixin csm;
	
	public AbstractAdmin() {
	}

	protected Databaseuser getDatabaseUser(UserInfo ui, String userClass)
			throws Exception {
		ISecurityService securityService = SimpleSecurityService.getInstance();
		IDBCache dbCache = ServiceFactory.getDBCache(csm.getDbID());

		Map<String, User> userMap = securityService.getAllUsers(csm.getDbID());
		User u = (User) userMap.get(ui.getName());

		Databaseuser databaseUser = dbCache.getDatabaseUser(ui, u.getDbUser()
				.getName(), userClass);
		if (databaseUser == null) {
			System.err.println("databaseUser was null (from dbCache)");
		}
		return databaseUser;
	}

	public void shutdown() throws Exception {
		if (csm != null) {
			csm.shutdown();
		}
	}
}
