package clinical.tools.dbadmin;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import clinical.server.dao.ExperimentDAO;
import clinical.server.vo.Deriveddata;
import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.DAOFactory;
import clinical.web.IDerivedImageDataService;
import clinical.web.ServiceFactory;
import clinical.web.services.IJobProvenanceService;
import clinical.web.services.SecurityService;
import clinical.web.vo.JobProvenanceInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class MultiWFDBAdmin extends AbstractAdmin {

	public MultiWFDBAdmin(String usersXmlFile) throws Exception {
		csm = new ConnectionSupportMixin(usersXmlFile);
		csm.startup();

		SecurityService ss = SecurityService.getInstance(
				csm.getDbPoolService(), csm.getDbID(), csm.getDbType());
		ss.startup();

		// MinimalServiceFactory.setMimimalOpMode(true);
	}

	public void handle(String expName, String subjectID, Integer visitId,
			String derivedDirName) throws Exception {
		Connection con = null;
		try {
			con = csm.getConnection();
			con.setAutoCommit(false);
			Experiment exp = getExp(con, expName);

			IJobProvenanceService jps = ServiceFactory
					.getJobProvenanceService(csm.getDbID());

			List<JobProvenanceInfo> jpiList = jps.findJobProvenances(csm
					.getUi(), exp.getUniqueid().intValue(), subjectID, visitId);

			for (JobProvenanceInfo jpi : jpiList) {
				System.out.println(jpi);
			}

			IDerivedImageDataService didService = ServiceFactory
					.getDerivedImageDataService(csm.getDbID());

			List<Deriveddata> ddList = didService.findDerivedData(csm.getUi(),
					subjectID, exp.getUniqueid().intValue(), visitId, null);

			List<String> paths = new ArrayList<String>(ddList.size());
			for (Deriveddata dd : ddList) {
				paths.add(dd.getDatauri());
			}
			String commonRoot = FileUtils.findCommonRoot(paths);

			System.out.println("commonRoot:" + commonRoot);
			String derivedSuffix = "/derived";
			if (commonRoot.endsWith(derivedSuffix)) {
				commonRoot = commonRoot.substring(0, commonRoot.length()
						- derivedSuffix.length());
			}
			File crFile = new File(commonRoot);

			Set<String> ddPartSet = new HashSet<String>(11);
			List<File> derivedDirList = new ArrayList<File>(5);
			for (String path : paths) {
				String rest = path.substring(commonRoot.length());
				String[] parts = rest.split("\\/+");
				String ddPart = (parts[0].length() > 0) ? parts[0] : parts[1];
				if (!ddPartSet.contains(ddPart)) {
					ddPartSet.add(ddPart);
					File derivedDir = null;
					File f = new File(path);
					while (f != null) {
						if (f.getParentFile().equals(crFile)) {
							derivedDir = f;
							break;
						}
						f = f.getParentFile();
					}
					Assertion.assertNotNull(derivedDir);
					derivedDirList.add(derivedDir);
				}
			}

			System.out.println("Derived Data Directories");
			System.out.println("------------------------");
			for (File derivedDir : derivedDirList) {
				System.out.println(derivedDir);
			}

			String pathPrefix = null;

			if (derivedDirName != null) {
				for (File derivedDir : derivedDirList) {
					if (derivedDir.getName().equals(derivedDirName)) {
						pathPrefix = derivedDir.getAbsolutePath();
						break;
					}
				}
				if (pathPrefix != null) {
					didService.removeDerivedData(csm.getUi(), subjectID, exp
							.getUniqueid().intValue(), visitId, null,
							pathPrefix);

					File pathToRemove = new File(pathPrefix);
					if (pathToRemove.isDirectory()) {
						System.out.println("removing path:" + pathToRemove);
						FileUtils.deleteRecursively(pathToRemove);
					}
				}
			}
			con.commit();
		} catch (Exception x) {
			con.rollback();
			x.printStackTrace();
		} finally {
			csm.releaseConnection(con);
		}
	}

	public Experiment getExp(Connection con, String expName) throws Exception {
		ExperimentDAO dao = DAOFactory.createExperimentDAO(csm.getDbID());
		Experiment cr = new Experiment();
		cr.setName(expName);
		List<Experiment> list = dao.find(con, cr);
		if (list.isEmpty()) {
			return null;
		}
		return list.get(0);
	}

	public static void usage() {
		System.err
				.println("Usage:MultiWFDBAdmin -c <cmd> -s <subjectid> -e <exp-name>|-eid <exp-id> -v <visit-id> -d <derived-dir-name>\n");
		System.err.println("where\n");
		System.err
				.println("\t-c del - to delete the derived data and the corresponding derived image data from the system.\n");
		System.exit(1);
	}

	public static String getArgValue(int i, String[] args) {
		if (args.length <= i || args[i].startsWith("-")) {
			System.err.println("Missing value for " + args[i - 1]);
			usage();
		}
		return args[i];
	}

	public static void main(String[] args) throws Exception {
		if (args.length < 8) {
			usage();
		}
		String subjectID = null;
		String expName = null;
		//String expIdStr = null;
		Integer visitId = null;
		String derivedDirName = null;
		@SuppressWarnings("unused")
		String cmd = null;
		int i = 0;
		while (i < args.length) {
			if (args[i].equals("-c")) {
				cmd = getArgValue(i + 1, args);
				i += 2;
			} else if (args[i].equals("-s")) {
				subjectID = getArgValue(i + 1, args);
				i += 2;
			} else if (args[i].equals("-e")) {
				expName = getArgValue(i + 1, args);
				i += 2;
			} else if (args[i].equals("-v")) {
				visitId = GenUtils.toInt(getArgValue(i + 1, args), -1);
				i += 2;
			} else if (args[i].equals("-d")) {
				derivedDirName = getArgValue(i + 1, args);
				i += 2;
			} else {
				i++;
			}
		}
		if (subjectID == null || expName == null || visitId == null
				|| visitId.intValue() == -1) {
			usage();
		}

		MultiWFDBAdmin admin = null;
		try {
			admin = new MultiWFDBAdmin("users.xml");

			admin.handle(expName, subjectID, visitId, derivedDirName);
		} finally {
			if (admin != null) {
				admin.shutdown();
			}
		}

	}
}
