package clinical.tools.dbadmin.migration;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jdom.Element;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.server.dao.JobsDAO;
import clinical.server.vo.Animalspecies;
import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentfloat;
import clinical.server.vo.Assessmentinteger;
import clinical.server.vo.Assessmentscore;
import clinical.server.vo.Assessmenttimestamp;
import clinical.server.vo.Assessmentvarchar;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.ConfParams;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Dataobject;
import clinical.server.vo.Dataobjecttype;
import clinical.server.vo.Deriveddata;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Experiment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.JobProvParamType;
import clinical.server.vo.JobProvenance;
import clinical.server.vo.JobProvenanceParam;
import clinical.server.vo.Jobs;
import clinical.server.vo.Person;
import clinical.server.vo.Rawdata;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Researchgrouptype;
import clinical.server.vo.Storedassessment;
import clinical.server.vo.Subjexperiment;
import clinical.server.vo.VisitJob;
import clinical.tools.dbadmin.migration.VOMigrationManager.VOXMLPersister;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.DBUtils;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.UserInfo;

public class DestSaver {
	private String migrationXmlFile;
	VOMigrationManager migMan;
	private ConnectionSupportMixin csm;
	private ISequenceHelper sequenceHelper;
	final private static Object[] emptyArr = new Object[] {};

	public DestSaver(String migrationXmlFile, ConnectionSupportMixin csm)
			throws Exception {
		this.migrationXmlFile = migrationXmlFile;
		this.csm = csm;
		migMan = VOMigrationManager.getInstance();

		VOXMLPersister<Collectionequipment> cePersister = new VOXMLPersister<Collectionequipment>(
				Collectionequipment.class);
		migMan.register(cePersister);
		VOXMLPersister<Experiment> expPersister = new VOXMLPersister<Experiment>(
				Experiment.class);
		migMan.register(expPersister);
		VOXMLPersister<Humansubject> subjPersister = new VOXMLPersister<Humansubject>(
				Humansubject.class);
		migMan.register(subjPersister);
		VOXMLPersister<Subjexperiment> sePersister = new VOXMLPersister<Subjexperiment>(
				Subjexperiment.class);
		migMan.register(sePersister);

		VOXMLPersister<Researchgroup> rgPersister = new VOXMLPersister<Researchgroup>(
				Researchgroup.class);
		migMan.register(rgPersister);

		VOXMLPersister<Expcomponent> visitPersister = new VOXMLPersister<Expcomponent>(
				Expcomponent.class);
		migMan.register(visitPersister);
		VOXMLPersister<Expsegment> segPersister = new VOXMLPersister<Expsegment>(
				Expsegment.class);
		migMan.register(segPersister);
		VOXMLPersister<Assessment> asPersister = new VOXMLPersister<Assessment>(
				Assessment.class);
		migMan.register(asPersister);
		VOXMLPersister<Assessmentscore> scorePersister = new VOXMLPersister<Assessmentscore>(
				Assessmentscore.class);
		migMan.register(scorePersister);
		VOXMLPersister<Assessmentinteger> aiPersister = new VOXMLPersister<Assessmentinteger>(
				Assessmentinteger.class);
		migMan.register(aiPersister);
		VOXMLPersister<Assessmentfloat> afPersister = new VOXMLPersister<Assessmentfloat>(
				Assessmentfloat.class);
		migMan.register(afPersister);
		VOXMLPersister<Assessmentvarchar> avPersister = new VOXMLPersister<Assessmentvarchar>(
				Assessmentvarchar.class);
		migMan.register(avPersister);
		VOXMLPersister<Assessmenttimestamp> atPersister = new VOXMLPersister<Assessmenttimestamp>(
				Assessmenttimestamp.class);
		migMan.register(atPersister);
		VOXMLPersister<Storedassessment> saPersister = new VOXMLPersister<Storedassessment>(
				Storedassessment.class);
		migMan.register(saPersister);

		VOXMLPersister<Jobs> jobsPersister = new VOXMLPersister<Jobs>(
				Jobs.class);
		migMan.register(jobsPersister);
		VOXMLPersister<VisitJob> vjPersister = new VOXMLPersister<VisitJob>(
				VisitJob.class);
		migMan.register(vjPersister);

		VOXMLPersister<JobProvenance> jpPersister = new VOXMLPersister<JobProvenance>(
				JobProvenance.class);
		migMan.register(jpPersister);

		VOXMLPersister<JobProvenanceParam> jppPersister = new VOXMLPersister<JobProvenanceParam>(
				JobProvenanceParam.class);
		migMan.register(jppPersister);

		VOXMLPersister<JobProvParamType> jpptPersister = new VOXMLPersister<JobProvParamType>(
				JobProvParamType.class);
		migMan.register(jpptPersister);

		VOXMLPersister<Rawdata> rdPersister = new VOXMLPersister<Rawdata>(
				clinical.server.vo.Rawdata.class);
		migMan.register(rdPersister);
		VOXMLPersister<Deriveddata> ddPersister = new VOXMLPersister<Deriveddata>(
				Deriveddata.class);
		migMan.register(ddPersister);

		VOXMLPersister<Person> personPersister = new VOXMLPersister<Person>(
				Person.class);
		migMan.register(personPersister);

		VOXMLPersister<Dataobjecttype> dotPersister = new VOXMLPersister<Dataobjecttype>(
				Dataobjecttype.class);
		migMan.register(dotPersister);

		VOXMLPersister<Dataobject> doPersister = new VOXMLPersister<Dataobject>(
				Dataobject.class);
		migMan.register(doPersister);

		this.sequenceHelper = MinimalServiceFactory.getSequenceHelper(csm
				.getDbID());
	}

	public void fixJobContexts() throws Exception {
		Connection con = null;
		try {
			con = csm.getConnection();
			con.setAutoCommit(false);

			Element rootEl = FileUtils.loadXML(migrationXmlFile);
			List<?> voEls = rootEl.getChildren("vo");

			List<Experiment> expList = getVOList(voEls, Experiment.class);
			List<Jobs> destJobsList = findMatching(con, Jobs.class, null, null);

			Experiment exp2Add = expList.get(0);

			Experiment destExp = findMatchingVO(con, Experiment.class, "name",
					exp2Add.getName());

			List<VisitJob> destVJList = findMatching(con, VisitJob.class,
					"expId", destExp.getUniqueid());
			Set<BigDecimal> jobUniqueIDSet = new HashSet<BigDecimal>();
			for (VisitJob vj : destVJList) {
				jobUniqueIDSet.add(vj.getJobUniqueId());
			}

			JobsDAO dao = DAOFactory.createJobsDAO(csm.getDbID());
			for (Jobs job : destJobsList) {
				if (jobUniqueIDSet.contains(job.getUniqueid())) {
					JSONObject json = new JSONObject(job.getJobContext());
					JSONArray jsonArr = json.getJSONArray("viList");
					JSONObject js = jsonArr.getJSONObject(0);
					js.put("expId", destExp.getUniqueid().intValue());

					Jobs bean = new Jobs();
					String jsonStr = json.toString();
					// FIXME
					System.out.println("correcting job + " + job.getJobid());
					jsonStr = jsonStr.replaceAll("\\/home\\/bozyurt\\/data",
							"/data/cbfbirn/data");

					// json = new JSONObject(jsonStr);
					// System.out.println(json.toString(2));

					bean.setJobContext(jsonStr);
					Jobs cr = new Jobs();
					cr.setUniqueid(job.getUniqueid());

					dao.update(con, bean, cr);
				}
			}

			con.commit();
		} catch (Throwable t) {
			con.rollback();
			t.printStackTrace();

		} finally {
			if (con != null) {
				con.setAutoCommit(true);
			}
			csm.releaseConnection(con);
		}
	}

	public void putDataObjects() throws Exception {
		Connection con = null;
		// DBUtils.getDatabaseUser(csm.getDbID(), csm.getConnection(), userName)
		try {
			con = csm.getConnection();
			con.setAutoCommit(false);
			UserInfo ui = new UserInfo("admin", null, null);
			Databaseuser dbUser = DBUtils.getDatabaseUser(ui,
					Constants.USERCLASS_ADMIN, csm.getDbID());
			Element rootEl = FileUtils.loadXML(migrationXmlFile);
			List<?> voEls = rootEl.getChildren("vo");

			List<Experiment> expList = getVOList(voEls, Experiment.class);
			List<Dataobject> doList = getVOList(voEls, Dataobject.class);
			List<Dataobjecttype> dotList = getVOList(voEls,
					Dataobjecttype.class);
			List<Rawdata> rdList = getVOList(voEls, Rawdata.class);

			Experiment exp2Add = expList.get(0);
			String expName = exp2Add.getName();

			Experiment exp = findMatchingVO(con, Experiment.class, "name",
					expName);

			List<Dataobjecttype> destDOTList = findMatching(con,
					Dataobjecttype.class, null, null);
			Map<String, Dataobjecttype> destDOTMap = new HashMap<String, Dataobjecttype>(
					27);
			for (Dataobjecttype dot : destDOTList) {
				destDOTMap.put(dot.getObjecttype(), dot);
			}
			Map<BigDecimal, Dataobjecttype> srcDOTMap = new HashMap<BigDecimal, Dataobjecttype>(
					27);
			for (Dataobjecttype dot : dotList) {
				srcDOTMap.put(dot.getUniqueid(), dot);
			}

			List<Rawdata> destRDList = findMatching(con, Rawdata.class,
					"ncExperimentUniqueid", exp.getUniqueid());
			Map<String, Rawdata> destRDMap = new HashMap<String, Rawdata>();
			for (Rawdata rd : destRDList) {
				String relPath = getURIRelPath(rd.getDatauri(), exp);
				destRDMap.put(relPath, rd);
			}

			// keyed by the Rawdata id
			Map<BigDecimal, Dataobject> srcDOMap = new HashMap<BigDecimal, Dataobject>();
			for (Dataobject d : doList) {
				srcDOMap.put(d.getDataid(), d);
			}

			List<Dataobject> destDOList = findMatching(con, Dataobject.class,
					null, null);
			Map<BigDecimal, Dataobject> destDOMap = new HashMap<BigDecimal, Dataobject>();
			for (Dataobject d : destDOList) {
				destDOMap.put(d.getDataid(), d);
			}

			Map<BigDecimal, Rawdata> srcRDMap = new HashMap<BigDecimal, Rawdata>();
			for (Rawdata rd : rdList) {
				srcRDMap.put(rd.getUniqueid(), rd);
			}

			for (Dataobject d : doList) {
				Rawdata srcRD = srcRDMap.get(d.getDataid());
				Assertion.assertNotNull(srcRD);
				String relPath = getURIRelPath(srcRD.getDatauri(), exp);
				Rawdata destRD = destRDMap.get(relPath);
				Assertion.assertNotNull(destRD);

				Dataobjecttype srcDOT = srcDOTMap.get(d.getObjecttypeid());
				Assertion.assertNotNull(srcDOT);
				Dataobjecttype destDOT = destDOTMap.get(srcDOT.getObjecttype());
				Assertion.assertNotNull(destDOT);

				if (!destDOMap.containsKey(destRD.getUniqueid())) {
					d.setDataid(destRD.getUniqueid());
					d.setObjecttypeid(destDOT.getUniqueid());
					addVO(con, ui, dbUser, Dataobject.class, d);
				}
			}

			con.commit();
		} catch (Throwable t) {
			con.rollback();
			t.printStackTrace();

		} finally {
			if (con != null) {
				con.setAutoCommit(true);
			}
			csm.releaseConnection(con);
		}

	}

	public void putExpData() throws Exception {
		Connection con = null;
		// DBUtils.getDatabaseUser(csm.getDbID(), csm.getConnection(), userName)
		try {
			con = csm.getConnection();
			con.setAutoCommit(false);
			UserInfo ui = new UserInfo("admin", null, null);
			Databaseuser dbUser = DBUtils.getDatabaseUser(ui,
					Constants.USERCLASS_ADMIN, csm.getDbID());
			Element rootEl = FileUtils.loadXML(migrationXmlFile);
			List<?> voEls = rootEl.getChildren("vo");

			List<Experiment> expList = getVOList(voEls, Experiment.class);
			List<Subjexperiment> seList = getVOList(voEls, Subjexperiment.class);
			List<Humansubject> hsList = getVOList(voEls, Humansubject.class);
			List<Researchgroup> rgList = getVOList(voEls, Researchgroup.class);
			List<Expcomponent> visitList = getVOList(voEls, Expcomponent.class);
			List<Expsegment> segList = getVOList(voEls, Expsegment.class);
			List<Person> personList = getVOList(voEls, Person.class);

			// List<Person> destPersonList = findMatching(con, Person.class,
			// null, null);

			List<ConfParams> cpList = findMatching(con, ConfParams.class,
					"name", "cbfbirn.data.root");
			Assertion.assertTrue(cpList.size() == 1);
			String dataRoot = cpList.get(0).getValue();

			Experiment exp2Add = expList.get(0);
			// find the contact person
			Person srcContact = null;
			for (Person p : personList) {
				if (p.getUniqueid().equals(exp2Add.getContactperson())) {
					srcContact = p;
					break;
				}
			}
			Assertion.assertNotNull(srcContact);
			Person destPerson = findMatchingVO(con, Person.class, "firstName",
					srcContact.getFirstName());
			Assertion.assertNotNull(destPerson);

			String expName = exp2Add.getName();

			exp2Add.setBaseuri(dataRoot + "/" + expName.replaceAll("\\s+", "_"));
			exp2Add.setContactperson(destPerson.getUniqueid());

			insertOrUpdateVO(con, ui, dbUser, Experiment.class, "name",
					expName, exp2Add, new String[] { "name", "baseuri" });
			Experiment exp = findMatchingVO(con, Experiment.class, "name",
					expName);

			// add human subjects
			List<Humansubject> oldHsList = findMatching(con,
					Humansubject.class, null, null);
			Set<String> oldSubjectIDSet = new HashSet<String>();
			for (Humansubject hs : oldHsList) {
				oldSubjectIDSet.add(hs.getSubjectid());
			}

			Animalspecies animal = findMatchingVO(con, Animalspecies.class,
					"name", "researchSubject");
			Assertion.assertNotNull(animal);
			for (Humansubject hs : hsList) {
				if (!oldSubjectIDSet.contains(hs.getSubjectid())) {
					hs.setNcAnimalspeciesUniqueid(animal.getUniqueid());
					addVO(con, ui, dbUser, Humansubject.class, hs);
				}
			}

			Researchgrouptype rgt = findMatchingVO(con,
					Researchgrouptype.class, "name", "control");
			Assertion.assertNotNull(rgt);

			List<Researchgroup> destRgList = findMatching(con,
					Researchgroup.class, "ncExperimentUniqueid",
					exp.getUniqueid());

			Map<BigDecimal, Researchgroup> rgMap = new HashMap<BigDecimal, Researchgroup>();
			Map<String, Researchgroup> destRgMap = new HashMap<String, Researchgroup>();
			for (Researchgroup rg : rgList) {
				rgMap.put(rg.getUniqueid(), rg);
				boolean found = false;
				for (Researchgroup drg : destRgList) {
					if (drg.getName().equals(rg.getName())) {
						found = true;
						break;
					}
				}
				if (!found) {
					rg.setNcResearchgrouptypeUniqueid(rgt.getUniqueid());
					rg.setNcExperimentUniqueid(exp.getUniqueid());
					addVO(con, ui, dbUser, Researchgroup.class, rg);
				}
			}

			destRgList = findMatching(con, Researchgroup.class,
					"ncExperimentUniqueid", exp.getUniqueid());
			for (Researchgroup drg : destRgList) {
				destRgMap.put(drg.getName(), drg);
			}

			List<Subjexperiment> destSeList = findMatching(con,
					Subjexperiment.class, "ncExperimentUniqueid",
					exp.getUniqueid());
			Set<String> destSeSubjectIDSet = new HashSet<String>();
			for (Subjexperiment se : destSeList) {
				destSeSubjectIDSet.add(se.getSubjectid());
			}

			for (Subjexperiment se : seList) {
				if (!destSeSubjectIDSet.contains(se.getSubjectid())) {
					se.setNcExperimentUniqueid(exp.getUniqueid());
					Researchgroup srcRg = rgMap.get(se
							.getNcResearchgroupUniqueid());
					Researchgroup destRg = destRgMap.get(srcRg.getName());

					se.setNcResearchgroupUniqueid(destRg.getUniqueid());
					addVO(con, ui, dbUser, Subjexperiment.class, se);
				}
			}

			// visits
			List<Expcomponent> destExpList = findMatching(con,
					Expcomponent.class, "ncExperimentUniqueid",
					exp.getUniqueid());
			Map<String, Expcomponent> destExpMap = new HashMap<String, Expcomponent>();
			for (Expcomponent ec : destExpList) {
				String key = ec.getSubjectid() + ":" + ec.getComponentid();
				destExpMap.put(key, ec);
			}
			for (Expcomponent visit : visitList) {
				String key = visit.getSubjectid() + ":"
						+ visit.getComponentid();
				if (!destExpMap.containsKey(key)) {
					visit.setNcExperimentUniqueid(exp.getUniqueid());
					addVO(con, ui, dbUser, Expcomponent.class, visit);
				}
			}

			// segments
			List<Expsegment> destSegList = findMatching(con, Expsegment.class,
					"ncExperimentUniqueid", exp.getUniqueid());
			Map<String, Expsegment> destSegMap = new HashMap<String, Expsegment>();
			for (Expsegment seg : destSegList) {
				String key = seg.getSubjectid() + ":" + seg.getComponentid()
						+ ":" + seg.getSegmentid();
				destSegMap.put(key, seg);
			}

			for (Expsegment seg : segList) {
				String key = seg.getSubjectid() + ":" + seg.getComponentid()
						+ ":" + seg.getSegmentid();
				if (!destSegMap.containsKey(key)) {
					seg.setNcExperimentUniqueid(exp.getUniqueid());
					addVO(con, ui, dbUser, Expsegment.class, seg);
				}
			}

			putAssessmentData(con, ui, voEls, dbUser, exp);

			putJobData(con, ui, voEls, dbUser, exp);

			con.commit();
		} catch (Throwable t) {
			con.rollback();
			t.printStackTrace();

		} finally {
			if (con != null) {
				con.setAutoCommit(true);
			}
			csm.releaseConnection(con);
		}
	}

	protected void putAssessmentData(Connection con, UserInfo ui,
			List<?> voEls, Databaseuser dbUser, Experiment exp)
			throws Throwable {

		List<Assessment> asList = getVOList(voEls, Assessment.class);
		List<Assessmentscore> scoreList = getVOList(voEls,
				Assessmentscore.class);
		List<Storedassessment> saList = getVOList(voEls, Storedassessment.class);
		List<Assessmentinteger> aiList = getVOList(voEls,
				Assessmentinteger.class);
		List<Assessmentvarchar> avList = getVOList(voEls,
				Assessmentvarchar.class);
		List<Assessmentfloat> afList = getVOList(voEls, Assessmentfloat.class);
		List<Assessmenttimestamp> atList = getVOList(voEls,
				Assessmenttimestamp.class);

		List<Assessment> destAsList = findMatching(con, Assessment.class, null,
				null);
		Map<String, Assessment> destAsNameMap = new HashMap<String, Assessment>();
		for (Assessment as : destAsList) {
			destAsNameMap.put(as.getName(), as);
		}

		Map<BigDecimal, Assessment> srcId2DestAsMap = new HashMap<BigDecimal, Assessment>();
		for (Assessment as : asList) {
			BigDecimal srcAsId = as.getUniqueid();
			if (!destAsNameMap.containsKey(as.getName())) {
				addVO(con, ui, dbUser, Assessment.class, as);
				Assessment destAs = findMatchingVO(con, Assessment.class,
						"name", as.getName());
				srcId2DestAsMap.put(srcAsId, destAs);
				// add scores also
				for (Assessmentscore score : scoreList) {
					if (score.getAssessmentid().equals(srcAsId)) {
						score.setAssessmentid(destAs.getUniqueid());
						addVO(con, ui, dbUser, Assessmentscore.class, score);
					}
				}
			} else {
				srcId2DestAsMap.put(srcAsId, destAsNameMap.get(as.getName()));
			}
		}

		List<Storedassessment> destSAList = findMatching(con,
				Storedassessment.class, "ncExperimentUniqueid",
				exp.getUniqueid());
		Map<String, Storedassessment> destSAMap = new HashMap<String, Storedassessment>();
		for (Storedassessment sa : destSAList) {
			String key = sa.getAssessmentid() + ":" + sa.getSubjectid() + ":"
					+ sa.getComponentid() + ":" + sa.getSegmentid();
			destSAMap.put(key, sa);
		}

		Map<BigDecimal, Storedassessment> srcId2DestSAMap = new HashMap<BigDecimal, Storedassessment>();
		for (Storedassessment sa : saList) {
			BigDecimal srcId = sa.getUniqueid();
			Assessment destAs = srcId2DestAsMap.get(sa.getAssessmentid());
			Assertion.assertNotNull(destAs);
			String key = destAs.getUniqueid() + ":" + sa.getSubjectid() + ":"
					+ sa.getComponentid() + ":" + sa.getSegmentid();
			if (!destSAMap.containsKey(key)) {
				sa.setAssessmentid(destAs.getUniqueid());
				sa.setNcExperimentUniqueid(exp.getUniqueid());
				addVO(con, ui, dbUser, Storedassessment.class, sa);
				srcId2DestSAMap.put(srcId, sa);
			} else {
				srcId2DestSAMap.put(srcId, destSAMap.get(key));
			}
		}

		Set<BigDecimal> destAsIdSet = new HashSet<BigDecimal>();
		for (Assessment as : srcId2DestAsMap.values()) {
			destAsIdSet.add(as.getUniqueid());
		}

		List<Assessmentinteger> destAiList = findMatching(con,
				Assessmentinteger.class, null, null);
		Map<String, Assessmentinteger> destAIMap = new HashMap<String, Assessmentinteger>();
		for (Iterator<Assessmentinteger> it = destAiList.iterator(); it
				.hasNext();) {
			Assessmentinteger ai = it.next();
			if (!destAsIdSet.contains(ai.getAssessmentid())) {
				it.remove();
			} else {
				String key = ai.getStoredassessmentid() + ":"
						+ ai.getAssessmentid() + ":" + ai.getSubjectid() + ":"
						+ ai.getScorename();
				destAIMap.put(key, ai);
			}
		}

		for (Assessmentinteger ai : aiList) {
			Assessment destAs = srcId2DestAsMap.get(ai.getAssessmentid());
			Assertion.assertNotNull(destAs);
			Storedassessment destSA = srcId2DestSAMap.get(ai
					.getStoredassessmentid());
			Assertion.assertNotNull(destSA);
			String key = destSA.getUniqueid() + ":" + destAs.getUniqueid()
					+ ":" + ai.getSubjectid() + ":" + ai.getScorename();
			if (!destAIMap.containsKey(key)) {
				ai.setKeyerid(dbUser.getUniqueid());
				ai.setRaterid(dbUser.getUniqueid());
				ai.setAssessmentid(destAs.getUniqueid());
				ai.setStoredassessmentid(destSA.getUniqueid());
				ai.setNcAssessmentdataUniqueid(null);
				addVO(con, ui, dbUser, Assessmentinteger.class, ai);
			}
		}

		List<Assessmentvarchar> destAvList = findMatching(con,
				Assessmentvarchar.class, null, null);
		Map<String, Assessmentvarchar> destAVMap = new HashMap<String, Assessmentvarchar>();
		for (Iterator<Assessmentvarchar> it = destAvList.iterator(); it
				.hasNext();) {
			Assessmentvarchar av = it.next();
			if (!destAsIdSet.contains(av.getAssessmentid())) {
				it.remove();
			} else {
				String key = av.getStoredassessmentid() + ":"
						+ av.getAssessmentid() + ":" + av.getSubjectid() + ":"
						+ av.getScorename();
				destAVMap.put(key, av);
			}
		}

		for (Assessmentvarchar av : avList) {
			Assessment destAs = srcId2DestAsMap.get(av.getAssessmentid());
			Assertion.assertNotNull(destAs);
			Storedassessment destSA = srcId2DestSAMap.get(av
					.getStoredassessmentid());
			Assertion.assertNotNull(destSA);
			String key = destSA.getUniqueid() + ":" + destAs.getUniqueid()
					+ ":" + av.getSubjectid() + ":" + av.getScorename();
			if (!destAVMap.containsKey(key)) {
				av.setKeyerid(dbUser.getUniqueid());
				av.setRaterid(dbUser.getUniqueid());
				av.setAssessmentid(destAs.getUniqueid());
				av.setStoredassessmentid(destSA.getUniqueid());
				// TEST
				av.setNcAssessmentdataUniqueid(null);
				addVO(con, ui, dbUser, Assessmentvarchar.class, av);
			}
		}

		List<Assessmentfloat> destAFList = findMatching(con,
				Assessmentfloat.class, null, null);
		Map<String, Assessmentfloat> destAFMap = new HashMap<String, Assessmentfloat>();
		for (Iterator<Assessmentfloat> it = destAFList.iterator(); it.hasNext();) {
			Assessmentfloat af = it.next();
			if (!destAsIdSet.contains(af.getAssessmentid())) {
				it.remove();
			} else {
				String key = af.getStoredassessmentid() + ":"
						+ af.getAssessmentid() + ":" + af.getSubjectid() + ":"
						+ af.getScorename();
				destAFMap.put(key, af);
			}
		}

		for (Assessmentfloat af : afList) {
			Assessment destAs = srcId2DestAsMap.get(af.getAssessmentid());
			Assertion.assertNotNull(destAs);
			Storedassessment destSA = srcId2DestSAMap.get(af
					.getStoredassessmentid());
			Assertion.assertNotNull(destSA);
			String key = destSA.getUniqueid() + ":" + destAs.getUniqueid()
					+ ":" + af.getSubjectid() + ":" + af.getScorename();
			if (!destAFMap.containsKey(key)) {
				af.setKeyerid(dbUser.getUniqueid());
				af.setRaterid(dbUser.getUniqueid());
				af.setAssessmentid(destAs.getUniqueid());
				af.setStoredassessmentid(destSA.getUniqueid());
				af.setNcAssessmentdataUniqueid(null);
				addVO(con, ui, dbUser, Assessmentfloat.class, af);
			}
		}

		List<Assessmenttimestamp> destATList = findMatching(con,
				Assessmenttimestamp.class, null, null);
		Map<String, Assessmenttimestamp> destATMap = new HashMap<String, Assessmenttimestamp>();
		for (Iterator<Assessmenttimestamp> it = destATList.iterator(); it
				.hasNext();) {
			Assessmenttimestamp at = it.next();
			if (!destAsIdSet.contains(at.getAssessmentid())) {
				it.remove();
			} else {
				String key = at.getStoredassessmentid() + ":"
						+ at.getAssessmentid() + ":" + at.getSubjectid() + ":"
						+ at.getScorename();
				destATMap.put(key, at);
			}
		}

		for (Assessmenttimestamp at : atList) {
			Assessment destAs = srcId2DestAsMap.get(at.getAssessmentid());
			Assertion.assertNotNull(destAs);
			Storedassessment destSA = srcId2DestSAMap.get(at
					.getStoredassessmentid());
			Assertion.assertNotNull(destSA);
			String key = destSA.getUniqueid() + ":" + destAs.getUniqueid()
					+ ":" + at.getSubjectid() + ":" + at.getScorename();
			if (!destATMap.containsKey(key)) {
				at.setKeyerid(dbUser.getUniqueid());
				at.setRaterid(dbUser.getUniqueid());
				at.setAssessmentid(destAs.getUniqueid());
				at.setStoredassessmentid(destSA.getUniqueid());
				at.setNcAssessmentdataUniqueid(null);
				addVO(con, ui, dbUser, Assessmenttimestamp.class, at);
			}
		}
	}

	protected void putJobData(Connection con, UserInfo ui, List<?> voEls,
			Databaseuser dbUser, Experiment exp) throws Throwable {
		List<VisitJob> vjList = getVOList(voEls, VisitJob.class);
		List<Jobs> jobList = getVOList(voEls, Jobs.class);
		List<JobProvenance> jpList = getVOList(voEls, JobProvenance.class);
		List<JobProvenanceParam> jppList = getVOList(voEls,
				JobProvenanceParam.class);
		List<JobProvParamType> jpptList = getVOList(voEls,
				JobProvParamType.class);
		List<Rawdata> rdList = getVOList(voEls, Rawdata.class);
		List<Deriveddata> ddList = getVOList(voEls, Deriveddata.class);
		List<Collectionequipment> ceList = getVOList(voEls,
				Collectionequipment.class);

		List<VisitJob> destVJList = findMatching(con, VisitJob.class, "expId",
				exp.getUniqueid());

		// assumption either all jobs for the same visit are migrated or none
		Map<BigDecimal, VisitJob> destVjMap = new HashMap<BigDecimal, VisitJob>();
		for (VisitJob vj : destVJList) {
			// String key = vj.getSubjectid() + ":" + vj.getComponentId();
			destVjMap.put(vj.getJobUniqueId(), vj);
		}

		List<Jobs> destJobsList = findMatching(con, Jobs.class, null, null);
		Map<String, Jobs> destJobsMap = new HashMap<String, Jobs>();
		for (Jobs jobs : destJobsList) {
			destJobsMap.put(jobs.getJobid(), jobs);
		}

		Map<BigDecimal, Jobs> srcId2DestJobMap = new HashMap<BigDecimal, Jobs>();
		for (Jobs job : jobList) {
			if (!job.getJobtype().equals("CBF Processing Workflow")
					|| job.getErrormsg() != null) {
				continue;
			}
			BigDecimal srcId = job.getUniqueid();
			if (!destJobsMap.containsKey(job.getJobid())) {
				job.setDownloadcount(new BigDecimal(0));
				job.setLastdownloadtime(null);
				addVO(con, ui, dbUser, Jobs.class, job);
				srcId2DestJobMap.put(srcId, job);
			} else {
				srcId2DestJobMap.put(srcId, destJobsMap.get(job.getJobid()));
			}
		}

		for (VisitJob vj : vjList) {
			Jobs destJob = srcId2DestJobMap.get(vj.getJobUniqueId());
			if (destJob != null) {
				if (!destVjMap.containsKey(destJob.getUniqueid())) {
					vj.setExpId(exp.getUniqueid());
					vj.setJobUniqueId(destJob.getUniqueid());
					addVO(con, ui, dbUser, VisitJob.class, vj);
				}
			}
		}

		List<JobProvenance> destJpList = findMatching(con, JobProvenance.class,
				null, null);

		Map<BigDecimal, JobProvenance> destJobProvMap = new HashMap<BigDecimal, JobProvenance>();
		for (Iterator<JobProvenance> it = destJpList.iterator(); it.hasNext();) {
			JobProvenance jp = it.next();
			destJobProvMap.put(jp.getJobUniqueid(), jp);
		}

		Map<BigDecimal, JobProvenance> srcId2DestJPMap = new HashMap<BigDecimal, JobProvenance>();
		for (JobProvenance jp : jpList) {
			BigDecimal srcId = jp.getUniqueid();
			Jobs destJob = srcId2DestJobMap.get(jp.getJobUniqueid());
			if (destJob != null) {
				if (!destJobProvMap.containsKey(destJob.getUniqueid())) {
					jp.setJobUniqueid(destJob.getUniqueid());
					String srcDataURI = jp.getDatauri();
					String dataURI = updateURI(srcDataURI, exp);

					jp.setDatauri(dataURI);
					addVO(con, ui, dbUser, JobProvenance.class, jp);
					srcId2DestJPMap.put(srcId, jp);
				} else {
					srcId2DestJPMap.put(srcId,
							destJobProvMap.get(destJob.getUniqueid()));
				}
			}
		}

		List<JobProvenanceParam> destJPPList = findMatching(con,
				JobProvenanceParam.class, null, null);
		Map<BigDecimal, JobProvenanceParam> destJPPMap = new HashMap<BigDecimal, JobProvenanceParam>();
		for (JobProvenanceParam jpp : destJPPList) {
			destJPPMap.put(jpp.getJobProvId(), jpp);
		}
		Map<BigDecimal, JobProvenanceParam> srcId2DestJPPMap = new HashMap<BigDecimal, JobProvenanceParam>();
		for (JobProvenanceParam jpp : jppList) {
			BigDecimal srcId = jpp.getUniqueid();
			JobProvenance destJP = srcId2DestJPMap.get(jpp.getJobProvId());
			Assertion.assertNotNull(destJP);
			if (!destJPPMap.containsKey(destJP.getUniqueid())) {
				jpp.setJobProvId(destJP.getUniqueid());

				addVO(con, ui, dbUser, JobProvenanceParam.class, jpp);
				srcId2DestJPPMap.put(srcId, jpp);
			} else {
				srcId2DestJPPMap.put(srcId,
						destJPPMap.get(destJP.getUniqueid()));
			}
		}

		List<JobProvParamType> destJPPTList = findMatching(con,
				JobProvParamType.class, null, null);
		Map<String, JobProvParamType> destParamTypeMap = new HashMap<String, JobProvParamType>();
		for (JobProvParamType jppt : destJPPTList) {
			destParamTypeMap.put(jppt.getName(), jppt);
		}

		for (JobProvParamType jppt : jpptList) {
			if (!destParamTypeMap.containsKey(jppt.getName())) {
				addVO(con, ui, dbUser, JobProvParamType.class, jppt);
			}
		}

		// prep scanner map
		List<Collectionequipment> destCEList = findMatching(con,
				Collectionequipment.class, null, null);
		Map<BigDecimal, Collectionequipment> srcId2DestCEMap = new HashMap<BigDecimal, Collectionequipment>();
		for (Collectionequipment ce : ceList) {
			for (Collectionequipment destCE : destCEList) {
				if (ce.getModel().equals(destCE.getModel())
						&& ce.getMake().equals(destCE.getMake())) {
					srcId2DestCEMap.put(ce.getUniqueid(), destCE);
					break;
				}
			}
		}

		List<Rawdata> destRDList = findMatching(con, Rawdata.class,
				"ncExperimentUniqueid", exp.getUniqueid());
		Map<String, Rawdata> destRDMap = new HashMap<String, Rawdata>();
		for (Rawdata rd : destRDList) {
			String relPath = getURIRelPath(rd.getDatauri(), exp);
			destRDMap.put(relPath, rd);
		}

		for (Rawdata rd : rdList) {
			String relPath = getURIRelPath(rd.getDatauri(), exp);
			if (!destRDMap.containsKey(relPath)) {
				Collectionequipment destCE = srcId2DestCEMap.get(rd
						.getNcColequipmentUniqueid());
				Assertion.assertNotNull(destCE);
				File srcFile = new File(rd.getDatauri());

				rd.setNcColequipmentUniqueid(destCE.getUniqueid());
				rd.setDatauri(updateURI(rd.getDatauri(), exp));
				rd.setNcExperimentUniqueid(exp.getUniqueid());

				addVO(con, ui, dbUser, Rawdata.class, rd);

				File destFile = new File(rd.getDatauri());
				if (!destFile.exists()) {
					destFile.getParentFile().mkdirs();
					if (!srcFile.exists()) {
						System.err.println("Source file does not exists:"
								+ srcFile);
						System.out.println("Skipping copying...");
					} else {
						if (srcFile.isDirectory()) {
							destFile.mkdirs();
							FileUtils.copyDirRecursively(srcFile, destFile);
						} else {
							FileUtils.copyFile(srcFile.getAbsolutePath(),
									destFile.getAbsolutePath());
						}
					}
				} else {
					if (srcFile.exists()) {
						if (srcFile.isFile()) {
							if (destFile.length() != srcFile.length()) {
								System.out
										.println("recopying file:" + destFile);
								FileUtils.copyFile(srcFile.getAbsolutePath(),
										destFile.getAbsolutePath());
							}
						}
					}

				}

			} else {
				Rawdata destRD = destRDMap.get(relPath);
				File destFile = new File(destRD.getDatauri());
				if (!destFile.exists()) {
					File srcFile = new File(rd.getDatauri());
					destFile.getParentFile().mkdirs();
					if (srcFile.isDirectory()) {
						destFile.mkdirs();
						FileUtils.copyDirRecursively(srcFile, destFile);
					} else {
						FileUtils.copyFile(srcFile.getAbsolutePath(),
								destFile.getAbsolutePath());
					}
				} else {
					File srcFile = new File(rd.getDatauri());
					if (srcFile.exists()) {
						if (srcFile.isFile()) {
							if (destFile.length() != srcFile.length()) {
								System.out
										.println("recopying file:" + destFile);
								FileUtils.copyFile(srcFile.getAbsolutePath(),
										destFile.getAbsolutePath());
							}
						}
					}

				}
				File parent = destFile.getParentFile();

				if (parent.isDirectory()
						&& parent.getName().startsWith("Visit_")) { // destFile.isFile())
																	// {
					File contentsFile = new File(destFile.getParentFile(),
							"CONTENTS");
					if (!contentsFile.exists()) {
						File srcFile = new File(rd.getDatauri());
						srcFile = new File(srcFile.getParentFile(), "CONTENTS");
						System.out.println("writing CONTENTS file:"
								+ contentsFile);
						FileUtils.copyFile(srcFile.getAbsolutePath(),
								contentsFile.getAbsolutePath());
					}
				}
			}
		}

		List<Deriveddata> destDDList = findMatching(con, Deriveddata.class,
				"ncExperimentUniqueid", exp.getUniqueid());
		Map<String, Deriveddata> destDDMap = new HashMap<String, Deriveddata>();
		for (Deriveddata dd : destDDList) {
			String relPath = getURIRelPath(dd.getDatauri(), exp);
			destDDMap.put(relPath, dd);
		}
		for (Deriveddata dd : ddList) {
			String relPath = getURIRelPath(dd.getDatauri(), exp);
			if (!destDDMap.containsKey(relPath)) {
				File srcFile = new File(dd.getDatauri());
				if (!srcFile.exists()) {
					System.out
							.println("Stale Deriveddata record! Datauri points to no file! :"
									+ srcFile);
					System.out.println("Skipping");
					continue;
				}
				dd.setDatauri(updateURI(dd.getDatauri(), exp));
				dd.setNcExperimentUniqueid(exp.getUniqueid());
				addVO(con, ui, dbUser, Deriveddata.class, dd);
				File destFile = new File(dd.getDatauri());
				if (!destFile.exists()) {
					destFile.getParentFile().mkdirs();
					FileUtils.copyFile(srcFile.getAbsolutePath(),
							destFile.getAbsolutePath());

					if (srcFile.getName().equals("fmri_struct.mat")) {
						File gmSrcFile = new File(srcFile.getParentFile(),
								"gm.txt");
						if (gmSrcFile.exists()) {
							File gmDestFile = new File(
									destFile.getParentFile(), "gm.txt");
							if (!gmDestFile.exists()) {
								FileUtils.copyFile(gmSrcFile.getAbsolutePath(),
										gmDestFile.getAbsolutePath());
							}
						}
					}
				}
			} else {
				Deriveddata destDD = destDDMap.get(relPath);
				File destFile = new File(destDD.getDatauri());
				if (!destFile.exists()) {
					File srcFile = new File(dd.getDatauri());
					if (srcFile.exists()) {
						destFile.getParentFile().mkdirs();
						FileUtils.copyFile(srcFile.getAbsolutePath(),
								destFile.getAbsolutePath());
					} else {
						System.out
								.println("Stale Deriveddata record! Datauri points to no file! :"
										+ srcFile);
					}
				}

				if (destFile.exists()) {
					// special case for gm.txt
					File srcFile = new File(dd.getDatauri());
					if (srcFile.getName().equals("fmri_struct.mat")) {
						File gmSrcFile = new File(srcFile.getParentFile(),
								"gm.txt");
						if (gmSrcFile.exists()) {
							File gmDestFile = new File(
									destFile.getParentFile(), "gm.txt");
							if (!gmDestFile.exists()) {
								FileUtils.copyFile(gmSrcFile.getAbsolutePath(),
										gmDestFile.getAbsolutePath());
							}
						}
					}
				}
			}
		}

	}

	public static String getURIRelPath(String srcDataURI, Experiment exp) {
		String expName = exp.getName().replaceAll("\\s+", "_");
		int idx = srcDataURI.indexOf(expName);
		Assertion.assertTrue(idx != -1);
		String relPath = srcDataURI.substring(idx + expName.length());
		return relPath;
	}

	public String updateURI(String srcDataURI, Experiment exp) {
		String expName = exp.getName().replaceAll("\\s+", "_");
		int idx = srcDataURI.indexOf(expName);
		Assertion.assertTrue(idx != -1);
		String relPath = srcDataURI.substring(idx + expName.length());
		String dataURI = exp.getBaseuri() + relPath;
		return dataURI;
	}

	public <T> void updateCommonFields(T vo, Databaseuser dbUser, UserInfo ui)
			throws Exception {
		String theVOClazzName = vo.getClass().getSimpleName();
		@SuppressWarnings("unchecked")
		VOXMLPersister<T> persister = (VOXMLPersister<T>) migMan
				.get(theVOClazzName);

		if (persister.hasProperty("moduser")) {
			persister.setValue(vo, "moduser", dbUser.getUniqueid());
		}
		if (persister.hasProperty("owner")) {
			persister.setValue(vo, "owner", dbUser.getUniqueid());
		}
		if (persister.hasProperty("tableid")) {
			String tableName = toTableName(theVOClazzName);
			BigDecimal tableID = DBUtils.getTableID(ui, tableName,
					csm.getDbID());
			persister.setValue(vo, "tableid", tableID);
		}

	}

	public static String toTableName(String voClassName) {
		StringBuilder sb = new StringBuilder();
		sb.append("NC");
		char[] carr = voClassName.toCharArray();
		for (char c : carr) {
			if (Character.isUpperCase(c)) {
				sb.append('_').append(c);
			} else {
				sb.append(Character.toUpperCase(c));
			}
		}
		return sb.toString();
	}

	@SuppressWarnings("unchecked")
	public <T> List<T> getVOList(List<?> voEls, Class<T> voClazz)
			throws Exception {
		List<T> voList = new ArrayList<T>();
		String theVOClazzName = voClazz.getSimpleName();
		VOXMLPersister<? extends Object> persister = migMan.get(theVOClazzName);
		for (Object o : voEls) {
			Element voEl = (Element) o;
			String voClassName = voEl.getAttributeValue("voName");
			if (voClassName.equals(theVOClazzName)) {
				voList.add((T) persister.fromXml(voEl));
			}
		}
		return voList;
	}

	public <T> void addVO(Connection con, UserInfo ui, Databaseuser dbUser,
			Class<T> voClazz, T vo2Add) throws Exception {
		String className = voClazz.getSimpleName();
		@SuppressWarnings("unchecked")
		VOXMLPersister<T> persister = (VOXMLPersister<T>) migMan.get(voClazz
				.getSimpleName());
		Class<DAOFactory> dfClazz = DAOFactory.class;
		Method m = dfClazz.getMethod(
				"create" + voClazz.getSimpleName() + "DAO", String.class);

		Object dao = m.invoke(null, csm.getDbID());

		Class<?> daoClazz = dao.getClass();
		BigDecimal uniqueId = sequenceHelper.getNextUID(con,
				voClazz.getSimpleName(), "uniqueid");

		updateCommonFields(vo2Add, dbUser, ui);
		if (persister.hasProperty("uniqueid")) {
			persister.setValue(vo2Add, "uniqueid", uniqueId);
			System.out.println(className + " uniqueId:" + uniqueId);
			if (persister.hasProperty("ncAssessmentdataUniqueid")) {
				persister
						.setValue(vo2Add, "ncAssessmentdataUniqueid", uniqueId);
				System.out.println(className + " ncAssessmentdataUniqueid:"
						+ uniqueId);
			}
		}

		Method addMethod = daoClazz.getMethod("insert", Connection.class,
				voClazz);
		try {
			addMethod.invoke(dao, con, vo2Add);
		} catch (Exception x) {
			System.out.println(vo2Add);
			throw x;
		}
	}

	public <T, S> void insertOrUpdateVO(Connection con, UserInfo ui,
			Databaseuser dbUser, Class<T> voClazz, String propertyName,
			S value, T vo2AddOrUpdate, String[] updatePropNames)
			throws Exception {
		@SuppressWarnings("unchecked")
		VOXMLPersister<T> persister = (VOXMLPersister<T>) migMan.get(voClazz
				.getSimpleName());
		Class<DAOFactory> dfClazz = DAOFactory.class;
		Method m = dfClazz.getMethod(
				"create" + voClazz.getSimpleName() + "DAO", String.class);

		Object dao = m.invoke(null, csm.getDbID());

		Class<?> daoClazz = dao.getClass();
		List<T> mList = findMatching(con, voClazz, propertyName, value);
		if (mList.isEmpty()) {
			// add
			BigDecimal uniqueId = sequenceHelper.getNextUID(con,
					voClazz.getSimpleName(), "uniqueid");

			updateCommonFields(vo2AddOrUpdate, dbUser, ui);
			persister.setValue(vo2AddOrUpdate, "uniqueid", uniqueId);

			Method addMethod = daoClazz.getMethod("insert", Connection.class,
					voClazz);
			addMethod.invoke(dao, con, vo2AddOrUpdate);
		} else {
			// update
			T bean = createVO(voClazz, vo2AddOrUpdate, updatePropNames,
					persister);
			T cr = createVO(voClazz, propertyName, value);
			Method updateMethod = daoClazz.getMethod("update",
					Connection.class, voClazz, voClazz);
			updateMethod.invoke(dao, con, bean, cr);
		}
	}

	public <T, S> T findMatchingVO(Connection con, Class<T> voClazz,
			String propertyName, S value) throws Exception {
		List<T> list = findMatching(con, voClazz, propertyName, value);

		if (list.isEmpty()) {
			return null;
		}
		Assertion.assertTrue(list.size() == 1);
		return list.get(0);
	}

	public <T> List<T> findMatching(Connection con, Class<T> voClazz,
			Map<String, Object> pvMap) throws Exception {
		Class<DAOFactory> dfClazz = DAOFactory.class;
		Method m = dfClazz.getMethod(
				"create" + voClazz.getSimpleName() + "DAO", String.class);

		Object dao = m.invoke(null, csm.getDbID());
		T cr = createVO(voClazz, null, null);
		@SuppressWarnings("unchecked")
		VOXMLPersister<T> persister = (VOXMLPersister<T>) migMan.get(voClazz
				.getSimpleName());
		for (String propertyName : pvMap.keySet()) {
			Object value = pvMap.get(propertyName);
			persister.setValue(cr, propertyName, value);
		}

		Class<?> daoClazz = dao.getClass();
		Method findMethod = daoClazz.getMethod("find", Connection.class,
				voClazz);

		@SuppressWarnings("unchecked")
		List<T> results = (List<T>) findMethod.invoke(dao, con, cr);

		return results;
	}

	public <T, S> List<T> findMatching(Connection con, Class<T> voClazz,
			String propertyName, S value) throws Exception {
		Class<DAOFactory> dfClazz = DAOFactory.class;
		Method m = dfClazz.getMethod(
				"create" + voClazz.getSimpleName() + "DAO", String.class);

		Object dao = m.invoke(null, csm.getDbID());
		T cr = createVO(voClazz, propertyName, value);
		Class<?> daoClazz = dao.getClass();
		Method findMethod = daoClazz.getMethod("find", Connection.class,
				voClazz);

		@SuppressWarnings("unchecked")
		List<T> results = (List<T>) findMethod.invoke(dao, con, cr);

		return results;
	}

	public <T, S> T createVO(Class<T> voClazz, T fromVo,
			String[] propertyNames, VOXMLPersister<T> persister)
			throws Exception {
		Constructor<T> constructor = voClazz.getConstructor(new Class<?>[] {});
		T vo = constructor.newInstance(emptyArr);

		for (String pn : propertyNames) {
			Method readMethod = persister.getReadMethod(pn);
			Object value = readMethod.invoke(fromVo, emptyArr);
			persister.setValue(vo, pn, value);
		}

		return vo;
	}

	public <T, S> T createVO(Class<T> voClazz, String propertyName, S value)
			throws Exception {
		Constructor<T> constructor = voClazz.getConstructor(new Class<?>[] {});
		T vo = constructor.newInstance(emptyArr);
		if (propertyName != null && value != null) {
			String setterName = prepPropertyMethodName(propertyName, false);
			Method m = voClazz.getMethod(setterName, value.getClass());
			m.invoke(vo, value);
		}
		return vo;
	}

	public static String prepPropertyMethodName(String propertyName,
			boolean getter) {
		StringBuilder sb = new StringBuilder(propertyName.length() + 3);
		if (getter) {
			sb.append("get");
		} else {
			sb.append("set");
		}
		if (Character.isUpperCase(propertyName.charAt(0))) {
			sb.append(propertyName);
		} else {
			sb.append(Character.toUpperCase(propertyName.charAt(0)));
			sb.append(propertyName.substring(1));
		}
		return sb.toString();
	}

	public void load() throws Exception {
		Element rootEl = FileUtils.loadXML(migrationXmlFile);
		List<?> voEls = rootEl.getChildren("vo");
		for (Object o : voEls) {
			Element voEl = (Element) o;
			String voClassName = voEl.getAttributeValue("voName");
			VOXMLPersister<? extends Object> persister = migMan
					.get(voClassName);
			if (persister == null) {
				continue;
			}
			if (voClassName.equals("Experiment")) {
				Experiment exp = (Experiment) persister.fromXml(voEl);
				System.out.println(exp);
			}
		}
	}

	public static void main(String[] args) throws Exception {
		DestSaver ds = new DestSaver("/tmp/migration.xml", null);

		ds.load();
	}

}
