package clinical.tools.install;

import java.io.IOException;

public class Utils {
	public static String getUserInput(String prompt, String[] posValues,
			IUserInput ui) throws IOException {
		StringBuffer buf = new StringBuffer(128);
		buf.append(prompt);
		if (posValues != null) {
			buf.append(" (");
			for (int i = 0; i < posValues.length; i++) {
				if (i == 0) {
					buf.append('[');
				}
				buf.append(posValues[i]);
				if (i == 0) {
					buf.append(']');
				}

				if ((i + 1) < posValues.length)
					buf.append(",");
			}
			buf.append(" ) ");
		}
		buf.append(" >> ");

		String answer = ui.getInput(buf.toString());
		boolean ok = true;
		do {
			if (answer.length() > 0) {
				if (posValues != null && validAnswer(answer, posValues)) {
					break;
				} else if (posValues == null) {
					// if there are no choices return the first nonempty answer
					break;
				}
			} else {
				if (posValues != null) {
					// return the default answer
					return posValues[0];
				}
			}
			answer = ui.getInput(buf.toString());
		} while (!ok);

		return answer.trim();
	}

	public static boolean validAnswer(String answer, String[] posValues) {
		for (int i = 0; i < posValues.length; i++) {
			if (answer.equals(posValues[i]))
				return true;
		}
		return false;
	}
}
