/**
 * 
 */
package clinical.tools.install;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.jdom.Element;


public class WebUserInfo extends DBUserInfo {
	String dbUser;
	List<PrivilegeInfo> privileges = new LinkedList<PrivilegeInfo>();

	public void addPrivilege(PrivilegeInfo pi) {
		privileges.add(pi);
	}

	public void toXML(Element parent) {
		Element e = new Element("user");
		parent.addContent(e);
		e.setAttribute("name", name);
		e.setAttribute("pwd", password);
		e.setAttribute("dbid", dbID);
		e.setAttribute("dbuser", dbUser);
		Element pe = new Element("privileges");
		e.addContent(pe);
		for (Iterator<PrivilegeInfo> iter = privileges.iterator(); iter
				.hasNext();) {
			PrivilegeInfo pi = iter.next();
			pi.toXML(pe);
		}
	}
}