package clinical.tools.utils;

import java.util.ArrayList;
import java.util.List;

import clinical.utils.Field;
import clinical.utils.PFileHeaderUtils;
import clinical.web.vo.HeaderFieldType;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class PFileImageTypeChecker {

	public static void dumpHeaderFields(String pfilePath) throws Exception {
		List<HeaderFieldType> hftList = new ArrayList<HeaderFieldType>(5);
		hftList.add(new HeaderFieldType("tag", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("timestamp", HeaderFieldType.STRING));
		hftList.add(new HeaderFieldType("reps", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("dda", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("nIntlv", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("speprev", HeaderFieldType.STRING));
		hftList.add(new HeaderFieldType("mpphase", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("mppcasl", HeaderFieldType.INT));
		
		PFileHeaderUtils pfhu = new PFileHeaderUtils(pfilePath);
		pfhu.readHeader();
		Field<String> tsField = pfhu.getStringField("timestamp");
		Field<Integer> tagField = pfhu.getIntField("tag");
		Field<Integer> nprepField = pfhu.getIntField("nprep");
		Field<Integer> repsField = pfhu.getIntField("reps");
		Field<Integer> ddaField = pfhu.getIntField("dda");
		Field<Integer> nIntlvField = pfhu.getIntField("nIntlv");
		Field<String> speprevField = pfhu.getStringField("speprev");
		Field<Integer> mpphaseField = pfhu.getIntField("mpphase");
		Field<Integer> mppcaslField = pfhu.getIntField("mppcasl");
		
		System.out.println("tsField:" + tsField);
		System.out.println("tagField:" + tagField);
		System.out.println("nprepField:" + nprepField);
		System.out.println("repsField:" + repsField);
		System.out.println("ddaField:" + ddaField);
		System.out.println("nIntlvField:" +  nIntlvField);
		System.out.println("speprevField:" + speprevField);
		System.out.println("mpphaseField:" + mpphaseField);
		System.out.println("mppcaslField:" + mppcaslField);
	}
	
	
	
	static String usageText = "Usage:PFileImageTypeChecker <p-file>\n";
	
	public static void usage() {
		System.err.println(usageText);
		System.exit(1);
	}
	
	public static void main(String[] args) throws Exception {
		if (args.length != 1) {
			usage();
		}
		String pfile = args[0];
	    dumpHeaderFields(pfile);	
	}
}
