package clinical.upload;

public class ConversionUtils {

  private ConversionUtils() {}

  public static Integer toInt(String rawData) throws DataConversionException{
     Integer value = null;
     try {
        value = new Integer( Integer.parseInt(rawData) );
     } catch( NumberFormatException nfe) {
        throw new DataConversionException( nfe.getMessage() );
     }
     return value;
  }

  public static Boolean toBoolean(String rawData) throws DataConversionException{
    Boolean value = null;
    try {
      if (rawData.equals("1"))
         return new Boolean(true);
      else if (rawData.equals("0"))
         return new Boolean(false);
      value = new Boolean( Boolean.getBoolean(rawData) );
    } catch (NumberFormatException nfe) {
        throw new DataConversionException( nfe.getMessage() );
    }
    return value;
  }


  public static Float toFloat(String rawData) throws DataConversionException{
     Float value = null;
     try {
        value = new Float( Float.parseFloat(rawData) );
     } catch( NumberFormatException nfe) {
        throw new DataConversionException( nfe.getMessage() );
     }
     return value;
  }

}