package clinical.upload;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * 
 * @version $Id: DataLoader.java 91 2009-08-17 23:38:26Z bozyurt $
 * @author I. Burak Ozyurt
 */

public class DataLoader extends DefaultHandler {
	protected List<List<String>> rowDataList = new LinkedList<List<String>>();
	protected MetaDataLoader metaLoader;
	protected int rowSize = -1;
	protected boolean inRow = false;
	protected boolean firstRow = true;
	protected List<String> currentRow;
	protected int colCount = 0;
	protected String xmlFilename;

	protected SAXParser parser;

	public DataLoader(String filename, MetaDataLoader metaLoader, int size) {
		this.xmlFilename = filename;
		parser = new SAXParser();
		parser.setContentHandler(this);

		this.metaLoader = metaLoader;
		if (size > 0)
			rowSize = size;
	}

	public void loadData() throws IOException, SAXException {
		// Element root = doc.getRootElement();
		parser.parse(xmlFilename);
	}

	public List<List<String>> getRowDataList() {
		return rowDataList;
	}

	public void dumpData(Writer w) throws IOException {
		for (Iterator<List<String>> it = rowDataList.iterator(); it.hasNext();) {
			List<String> row = it.next();
			for (String element : row) {
				w.write(element);
				w.write(' ');
			}
			w.write(System.getProperty("line.separator"));
		}
		w.flush();

	}

	public void dumpData() throws IOException {
		dumpData(new OutputStreamWriter(System.out));
	}

	public void startElement(String uri, String local, String qName,
			Attributes attrs) {
		if (local.equals("row")) {
			inRow = true;
			currentRow = (rowSize > 0) ? new ArrayList<String>(rowSize)
					: new ArrayList<String>();
			return;
		}
		if (inRow && local.equals("col")) {
			String newName = (String) metaLoader.getOld2NewNameMap().get(
					attrs.getValue("name"));
			ColumnInfo colInfo = (ColumnInfo) metaLoader.getColInfoMap().get(
					newName);
			if (colInfo != null) {
				if (firstRow) {
					colInfo.setColIdx(colCount);
					++colCount;
				}
				currentRow.add(attrs.getValue("value"));
			}

		}
	}

	public void endElement(String namespaceURI, String localName,
			String qualifiedName) {
		if (localName.equals("row")) {
			inRow = false;
			firstRow = false;
			rowDataList.add(currentRow);
		}
	}

	// for ContentHandler
	public void setDocumentLocator(Locator locator) {
	}

	public void startDocument() {
	}

	public void endDocument() {
	}

	public void characters(char[] text, int start, int length) {
	}

	public void startPrefixMapping(String prefix, String uri) {
	}

	public void endPrefixMapping(String prefix) {
	}

	public void ignorableWhitespace(char[] text, int start, int length)
			throws SAXException {
	}

	public void processingInstruction(String target, String data) {
	}

	public void skippedEntity(String name) {
	}

}