package clinical.utils;

import java.util.Properties;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * adapted from  Claude Duguay's mail client code.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: EmailSender.java 322 2011-01-21 23:39:05Z bozyurt $
 */
public class EmailSender extends Authenticator implements IEmailSender {
	protected String from;
    protected Session session;
    protected PasswordAuthentication authentication;
    private Log log = LogFactory.getLog(EmailSender.class);
   
    
    public EmailSender(String user, String host, String fromUser, String pwd, int port, boolean debug) {
    	this.from = fromUser;
    	
    	this.authentication = new PasswordAuthentication(user, pwd);
    	Properties props = new Properties();
    	props.put("mail.user", user);
    	
    	props.put("mail.smtp.host", host);
    	props.put("mail.smtp.port", String.valueOf(port));
    	
    	props.put("mail.debug", debug ? "true" : "false");
    	props.put("mail.store.protocol", "pop3");
    	props.put("mail.transport.protocol", "smtp");
    	this.session = Session.getInstance(props, this);
    }
    
    protected PasswordAuthentication getPasswordAuthentication() {
    	return authentication;
    }
    
    /* (non-Javadoc)
	 * @see clinical.utils.IEmailSender#sendMessage(java.lang.String, java.lang.String, java.lang.String)
	 */
    public void sendMessage(String to, String subject, String content)
    throws MessagingException {
        log.info("SENDING message from " + from + " to " + to);
        System.out.println("SENDING message from " + from + " to " + to);
        MimeMessage msg = new MimeMessage(session);
        msg.addRecipients(Message.RecipientType.TO, to);
        msg.setSubject(subject);
        msg.setText(content);
        
        Transport.send(msg);
    }
    
}
