package clinical.web;

import java.util.List;
import java.util.Map;

import clinical.server.vo.Tuplecolumns;
import clinical.server.vo.Tuplevarchar;
import clinical.web.common.UserInfo;
import clinical.web.common.query.Operator;
import clinical.web.common.vo.AnalysisExTupleInfo;
import clinical.web.common.vo.AnalysisResultSummary;

/**
 * @author I. Burak Ozyurt
 * @version $Id: IAnalysisResultService.java,v 1.1.2.1 2008/06/06 23:32:05
 *          bozyurt Exp $
 */
public interface IAnalysisResultService {

	public boolean hasAnalysisMetaData() throws Exception;

	public List<Tuplecolumns> getTupleColumnsForET(UserInfo ui,
			List<String> exTupleNames) throws Exception;

	public List<Tuplevarchar> getMeasurementGroupNamesForET(UserInfo ui,
			String mgName, List<Integer> extTupleIDList) throws Exception;

	public Map<String, AnalysisExTupleInfo> getExTuplesPerAnalysisAvail(
			UserInfo ui) throws Exception;

	public List<AnalysisResultSummary> queryForAnalysisResults(UserInfo ui,
			Operator root, List<Integer> experimentIDs, String queryScope,
			String primarySiteID) throws Exception;
}