package clinical.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;

/**
 * Interface to be implemented by all supported relational database SQL dialects.
 *
 * @author I. Burak Ozyurt
 * @version $Id: ISQLDialect.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public interface ISQLDialect {

  public String prepareSchemaObjectName(String schemaObjName);

  public String prepareString(String value);

  public String prepareBooleanPredicate(String prefix, boolean value);
  public String prepareBooleanValue(Boolean value);

  public String getDialectName();

  public void invokeSetter(Method m, Object vo, Object value, int colType) throws
  SQLException, InvocationTargetException, IllegalArgumentException, IllegalAccessException;

  public String endsWithFunction(String schemaColName, String suffix);
}