package clinical.web;

import java.sql.Connection;
import java.util.List;

import clinical.server.vo.Analysisresult;
import clinical.server.vo.Tupleclass;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.services.XCEDEDerivedDataServiceImpl.MeasurementInfo;
import clinical.xml.xcede2.AnalysisT;
import clinical.xml.xcede2.MeasurementGroupT;

/**
 * @author I. Burak Ozyurt
 * @version $Id: IXCEDEDerivedDataService.java,v 1.1 2008/03/14 19:20:54 bozyurt
 *          Exp $
 */
public interface IXCEDEDerivedDataService {

	public void deleteAnalysesForSubject(UserInfo ui, AnalysisT provenanceAT)
			throws Exception;

	public void addAnalysesForSubject(UserInfo ui, String subjectID,
			String expName, Integer visitID, String segmentName,
			AnalysisT provenanceAT, List<AnalysisT> remAtList,
			String shortAnalysisName, String snapshotID) throws Exception;

	public void addAnalysisForSubject(UserInfo ui, String subjectID,
			Integer experimentID, Integer visitID, Integer segmentID,
			Integer executedTransformID, AnalysisT analysis,
			String analysisTypeName) throws Exception;

	public List<Analysisresult> deleteAnalysesForSubject(UserInfo ui,
			String subjectID, Integer experimentID, Integer visitID,
			Integer segmentID) throws Exception;

	public List<Analysisresult> deleteAnalysesForSubject(Connection con,
			UserInfo ui, String subjectID, Integer experimentID,
			Integer visitID, Integer segmentID) throws Exception;

	public List<AnalysisT> getAnalysesForSubject(UserInfo ui, String subjectID,
			Integer experimentID) throws Exception;

	public void deleteExtendedTuple(UserInfo ui, String tupleName)
			throws BaseException;

	public void addExtendedTuple(UserInfo ui, String tupleName,
			MeasurementGroupT mg, String tupleClass, String tupleSubClass)
			throws BaseException;

	public void addMeasurementInfo(UserInfo ui, MeasurementInfo mi)
			throws BaseException;

	public void addTupleSubClass(UserInfo ui, String tupleClass,
			String tupleSubclass) throws Exception;

	public Tupleclass addTupleClass(UserInfo ui, String tupleClass)
			throws Exception;
}
