package clinical.web.actions;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.server.vo.Assessment;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Protocol;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Subjexperiment;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.IAppConfigService;
import clinical.web.IExperimentManagement;
import clinical.web.ISubjectAssessmentManagement;
import clinical.web.ISubjectVisitManagement;
import clinical.web.IUploadManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.helpers.GenderSelector;
import clinical.web.services.AppConfigService;
import clinical.web.services.IBugReportService;
import clinical.web.services.ICBFSearchService;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentResultSummary;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.CollectionEquipment;
import clinical.web.vo.ScoreValue;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;
import clinical.web.vo.upload.AssessmentType;
import clinical.web.vo.upload.BugReportInfo;
import clinical.web.vo.upload.ColEquipInfo;
import clinical.web.vo.upload.EnrolledSubject;
import clinical.web.vo.upload.ExperimentInfo;
import clinical.web.vo.upload.ProtocolInfo;
import clinical.web.vo.upload.RGInfo;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.vo.upload.VisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ASLUploadCommunicationAction.java 366 2011-05-05 20:06:27Z
 *          bozyurt $
 */

public class ASLUploadCommunicationAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(ASLUploadCommunicationAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.get.expinfo", "getExpInfo");
		map.put("action.get.visit.info", "getVisitInfo");
		map.put("action.upload.visit.info", "uploadVisit");
		map.put("action.authenticate", "authenticate");
		map.put("action.report.bug", "reportBug");
		map.put("action.get.basic.visit.info", "getBasicVisitInfo");
		map.put("action.subject.create.enroll", "createAndEnrollSubject");
		map.put("action.update.visitname", "updateVisitName");
		map.put("action.update.visitname.withid", "updateVisitNameWithID");
		map.put("action.get.asmeta", "getAssessmentMetadata");
		return map;
	}

	public ActionForward authenticate(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			log.info(">> authenticate");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			ia.authenticate(webUser, pwd, dbID);
		} catch (Throwable t) {
			log.error("ASLUploadCommunicationAction", t);
			JSONObject js = new JSONObject();
			if (t.getMessage() != null) {
				js.put("errMsg", t.getMessage());
			} else {
				js.put("errMsg", "authentication error");
			}
			prepJSONResponse(response, js);
		}
		return null;
	}

	public ActionForward getBasicVisitInfo(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			log.info(">> getBasicVisitInfo");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			String subjectID = request.getParameter("subjectID");
			String expIDStr = request.getParameter("expID");
			int expID = Integer.parseInt(expIDStr);
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);

			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			List<Visit> allVisits = isvm.getAllVisitsForSubject(ui, subjectID);
			Researchgroup rg = isvm.getResearchGroupForSubjectAndExperiment(ui,
					subjectID, expID);
			List<VisitInfo> viList = new ArrayList<VisitInfo>(allVisits.size());
			for (Visit v : allVisits) {
				if (v.getExperimentID() == expID) {
					if (authService.isAuthorized(ui, dbID, PrivilegeLabel.READ,
							expID)) {
						RGInfo rgInfo = null;
						if (rg != null) {
							rgInfo = new RGInfo(rg.getName(),
									rg.getDescription());
						}
						VisitInfo vi = new VisitInfo(v.getComponentID(),
								v.getName(), v.getDescription(),
								v.getSubjectID(), v.getVisitType(),
								v.getExperimentID(), new Date(v.getTs()
										.getTime()), rgInfo);

						viList.add(vi);
					}
				}
			}

			if (!viList.isEmpty()) {
				Map<Integer, VisitInfo> viMap = new HashMap<Integer, VisitInfo>(
						7);
				for (VisitInfo vi : viList) {
					viMap.put(vi.getVisitId(), vi);
				}
			}

			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("viList", jsArr);
			for (VisitInfo vi : viList) {
				jsArr.put(vi.toJSON());
			}

			prepJSONResponse(response, js);

		} catch (Throwable t) {
			log.error("ASLUploadCommunicationAction", t);
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("viList", jsArr);
			prepJSONResponse(response, js);
		}
		return null;

	}

	public ActionForward getVisitInfo(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info(">> getVisitInfo");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			String subjectID = request.getParameter("subjectID");
			String expIDStr = request.getParameter("expID");
			int expID = Integer.parseInt(expIDStr);
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);

			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			ISubjectAssessmentManagement isam = ServiceFactory
					.getSubjectAssessmentManagement(dbID);
			Assessment assessment = isam.getAssessment(ui,
					"Subject Information");
			List<AssessmentScoreValues> asvList = null;
			if (assessment != null) {
				AssessmentInfo ai = new AssessmentInfo(assessment
						.getAssessmentid().intValue(), assessment.getName(),
						null, -1, -1);
				List<AssessmentInfo> asiList = new ArrayList<AssessmentInfo>(1);
				asiList.add(ai);

				asvList = isam.getAssessmentValuesForSubject(ui, subjectID,
						expID, asiList, -1, true);
			}
			List<Visit> allVisits = isvm.getAllVisitsForSubject(ui, subjectID);
			Researchgroup rg = isvm.getResearchGroupForSubjectAndExperiment(ui,
					subjectID, expID);
			List<VisitInfo> viList = new ArrayList<VisitInfo>(allVisits.size());
			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, Collectionequipment> colEqMap = getColEqMap(ui, dbCache);

			for (Visit v : allVisits) {
				if (v.getExperimentID() == expID) {
					if (authService.isAuthorized(ui, dbID, PrivilegeLabel.READ,
							expID)) {
						RGInfo rgInfo = null;
						if (rg != null) {
							rgInfo = new RGInfo(rg.getName(),
									rg.getDescription());
						}
						VisitInfo vi = new VisitInfo(v.getComponentID(),
								v.getName(), v.getDescription(),
								v.getSubjectID(), v.getVisitType(),
								v.getExperimentID(), new Date(v.getTs()
										.getTime()), rgInfo);
						for (VisitSegment vs : v.getVisitSegments()) {
							Integer colEqId = null;
							if (vs.getEquipment() != null) {
								String key = getEqKey(vs.getEquipment());
								Collectionequipment ce = colEqMap.get(key);

								if (ce != null) {
									colEqId = ce.getUniqueid().intValue();
								}
							}
							SegmentInfo si = new SegmentInfo(vs.getName(),
									vs.getDescription(),
									vs.getProtocolVersion(),
									vs.getProtocolID(), colEqId, new Date(vs
											.getTimeStamp().getTime()), null);
							vi.addSI(si);
						}

						viList.add(vi);
					}
				}
			}
			if (!viList.isEmpty() && (asvList != null && !asvList.isEmpty())) {
				Map<Integer, VisitInfo> viMap = new HashMap<Integer, VisitInfo>(
						7);
				for (VisitInfo vi : viList) {
					viMap.put(vi.getVisitId(), vi);
				}
				for (AssessmentScoreValues asv : asvList) {
					VisitInfo vi = viMap.get(asv.getVisitID());
					if (vi != null) {
						AssessmentType at = toAssessmentType(asv);
						vi.addAssessment(at);
					}
				}
			}

			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("viList", jsArr);
			for (VisitInfo vi : viList) {
				jsArr.put(vi.toJSON());
			}

			prepJSONResponse(response, js);

		} catch (Throwable t) {
			log.error("ASLUploadCommunicationAction", t);
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("viList", jsArr);
			prepJSONResponse(response, js);
		}
		return null;

	}

	public static AssessmentType toAssessmentType(AssessmentScoreValues asv) {
		AssessmentType at = new AssessmentType(asv.getAssessmentName(), null);
		for (ScoreValue sv : asv.getScoreValues()) {
			clinical.web.vo.upload.ScoreValue scoreValue = new clinical.web.vo.upload.ScoreValue(
					sv.getName(), sv.getValue());
			at.addValue(scoreValue);
		}
		return at;
	}

	public static Map<String, Collectionequipment> getColEqMap(UserInfo ui,
			IDBCache dbCache) throws Exception {
		Map<String, Collectionequipment> eqMap = new HashMap<String, Collectionequipment>(
				11);
		List<Collectionequipment> ceList = dbCache.getCollectionEquipments(ui,
				false);
		for (Collectionequipment ce : ceList) {
			StringBuilder sb = new StringBuilder();
			sb.append(ce.getMake()).append(':').append(ce.getModel());
			String key = sb.toString();
			eqMap.put(key, ce);
		}
		return eqMap;
	}

	public static String getEqKey(CollectionEquipment cei) {
		StringBuilder sb = new StringBuilder();
		sb.append(cei.getMake()).append(':').append(cei.getModel());
		return sb.toString();
	}

	public ActionForward reportBug(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			log.info(">> reportBug");
			String dbID = getDBID();
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);
			String jsonStr = request.getParameter("bugReport");
			JSONObject js = new JSONObject(jsonStr);
			System.out.println(js.toString(3));
			BugReportInfo bri = BugReportInfo.initializeFromJSON(js);

			IBugReportService bugReportService = ServiceFactory
					.getBugReportService(dbID);

			bugReportService.addBugReport(ui, bri.getSubjectID(),
					bri.getExpId(), bri.getVisitId(), bri.getReportingUser(),
					bri.getComments());

		} catch (Throwable t) {
			log.error("ASLUploadCommunicationAction", t);
		}
		return null;
	}

	public ActionForm getAssessmentMetadata(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			log.info(">> getAssessmentMetadata");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");

			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);
			String assessmentName = request.getParameter("assessmentName");
			ICBFSearchService cbfSearchService = ServiceFactory
					.getCBFSearchService(dbID);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			AssessmentSelectionInfo asi = cbfSearchService
					.getAssessmentQueryMetadata(ui, assessmentName,
							primarySiteID);

			JSONObject json = asi.toJSON(new JSONObject());
			prepJSONResponse(response, json);

		} catch (Throwable t) {
			log.error("getAssessmentMetadata", t);
			JSONObject js = new JSONObject();
			if (t.getMessage() != null) {
				js.put("errMsg", t.getMessage());
			} else {
				js.put("errMsg", "getAssessmentMetadata error");
			}
			prepJSONResponse(response, js);
		}
		return null;
	}

	public ActionForm updateVisitNameWithID(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			log.info(">> updateVisitNameWithID");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);
			String visitName = request.getParameter("visitName");
			String subjectID = request.getParameter("subjectID");
			int visitID = GenUtils.toInt(request.getParameter("visitID"), -1);
			String expName = request.getParameter("expName");
			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			List<Visit> allVisitsForSubject = isvm.getAllVisitsForSubject(ui,
					subjectID);
			if (allVisitsForSubject.isEmpty()) {
				return null;
			}
			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, Experiment> experimentMap = dbCache.getExperimentMap(
					ui, false);
			Experiment theExp = experimentMap.get(expName);
			Assertion.assertNotNull(theExp);
			Visit theVisit = null;
			for (Visit v : allVisitsForSubject) {
				if (v.getExperimentID() == theExp.getUniqueid().intValue()
						&& visitID == v.getComponentID()) {
					theVisit = v;
					break;
				}
			}
			Assertion.assertNotNull(theVisit);

			isvm.updateVisitName(ui, theExp.getUniqueid().intValue(),
					subjectID, visitID, visitName);
		} catch (Throwable t) {
			log.error("updateVisitName", t);
			JSONObject js = new JSONObject();
			if (t.getMessage() != null) {
				js.put("errMsg", t.getMessage());
			} else {
				js.put("errMsg", "updateVisitName error");
			}
			prepJSONResponse(response, js);
		}
		return null;
	}

	public ActionForm updateVisitName(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info(">> updateVisitName");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);
			String jsonQuery = request.getParameter("filterJSON");
			String visitName = request.getParameter("visitName");
			String subjectID = request.getParameter("subjectID");
			String visitDate = request.getParameter("visitDate");
			String expName = request.getParameter("expName");
			ICBFSearchService css = ServiceFactory.getCBFSearchService(dbID);
			JSONObject js = new JSONObject(jsonQuery);
			List<AssessmentResultSummary> asrList = css.searchByAssessment(ui,
					js);
			AssessmentResultSummary theASR = null;
			for (AssessmentResultSummary asr : asrList) {
				if (asr.getSubjectID().equals(subjectID)
						&& asr.getExpName().equals(expName)
						&& asr.hasSameTimeStamp(visitDate)) {

					theASR = asr;
					break;
				}
			}
			Assertion.assertNotNull(theASR);
			Set<Integer> uniqueVisitIdSet = theASR.getUniqueVisitIdSet();
			Assertion.assertTrue(uniqueVisitIdSet.size() == 1);
			Integer visitID = uniqueVisitIdSet.iterator().next();

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);

			Integer expID = GenUtils.toInt(theASR.getExpID(), -1);
			Assertion.assertTrue(expID.intValue() != -1);
			isvm.updateVisitName(ui, expID, subjectID, visitID, visitName);
		} catch (Throwable t) {
			log.error("updateVisitName", t);
			JSONObject js = new JSONObject();
			if (t.getMessage() != null) {
				js.put("errMsg", t.getMessage());
			} else {
				js.put("errMsg", "updateVisitName error");
			}
			prepJSONResponse(response, js);
		}
		return null;
	}

	public ActionForward createAndEnrollSubject(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			log.info(">> createAndEnrollSubject");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");

			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);

			String expName = request.getParameter("expName");

			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> experiments = dbCache.getExperiments(ui, false);
			Experiment theExp = null;
			boolean canCreate = false;
			for (Experiment exp : experiments) {
				Integer expID = exp.getUniqueid().intValue();
				if (authService.isAuthorized(ui, dbID,
						PrivilegeLabel.CREATE_SUBJECT, expID)) {
					if (exp.getName().equals(expName)) {
						canCreate = true;
						theExp = exp;
						break;
					}
				}
			}
			if (!canCreate) {
				throw new Exception("User not authorized to create a subject!");
			}

			String subjectID = request.getParameter("subjectID");
			String birthDate = request.getParameter("birthDate");
			String gender = request.getParameter("gender");
			String diagnosis = request.getParameter("diagnosis");

			List<Researchgroup> researchGroups = dbCache.getResearchGroups(ui,
					true);
			Researchgroup theRG = null;
			for (Researchgroup rg : researchGroups) {
				if (rg.getName().equals(diagnosis)
						&& rg.getNcExperimentUniqueid().equals(
								theExp.getUniqueid())) {
					theRG = rg;
					break;
				}
			}
			if (theRG == null) {
				throw new Exception("There are no research groups matching '"
						+ diagnosis + "'!");
			}

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);

			Subject subject = new Subject();
			subject.setCreator(ui.getName());
			subject.setSubjectID(subjectID);
			subject.setBirthDate(birthDate);

			String gsGender = GenderSelector.MALE;
			if (gender.equalsIgnoreCase("f")
					|| gender.equalsIgnoreCase(GenderSelector.FEMALE)) {
				gsGender = GenderSelector.FEMALE;
			}
			subject.getGenderSelector().setSelectedGender(gsGender);

			int experimentID = theExp.getUniqueid().intValue();
			int researchGroupID = theRG.getUniqueid().intValue();
			isvm.createAndEnrollSubject(ui, subject, experimentID,
					researchGroupID);

		} catch (Throwable t) {
			log.error("ASLUploadCommunicationAction", t);
			JSONObject js = new JSONObject();
			if (t.getMessage() != null) {
				js.put("errMsg", t.getMessage());
			} else {
				js.put("errMsg", "createAndEnrollSubject error");
			}
			prepJSONResponse(response, js);
		}
		return null;
	}

	public ActionForward uploadVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			log.info(">> uploadVisit");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			String stagingIdStr = request.getParameter("stagingId");
			int stagingId = GenUtils.toInt(stagingIdStr, -1);
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);

			String jsonStr = request.getParameter("visitInfo");
			JSONObject js = new JSONObject(jsonStr);
			System.out.println(js.toString(3));
			VisitInfo visitInfo = VisitInfo.initializeFromJSON(js);

			IUploadManagementService ums = ServiceFactory
					.getUploadManagementService(dbID);

			ums.uploadVisit(ui, visitInfo, stagingId);

		} catch (Throwable t) {
			log.error("ASLUploadCommunicationAction", t);
			JSONObject js = new JSONObject();
			if (t.getMessage() != null) {
				js.put("errMsg", t.getMessage());
			} else {
				js.put("errMsg", "uploadVisit error");
			}
			prepJSONResponse(response, js);
		}
		return null;
	}

	public ActionForward getExpInfo(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			log.info(">> getExpInfo");
			String dbID = getDBID();
			// authenticate user
			String webUser = request.getParameter("user");
			String pwd = request.getParameter("pwd");
			IAuthenticationService ia = ServiceFactory
					.getAuthenticationService();
			UserInfo ui = ia.authenticate(webUser, pwd, dbID);

			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Researchgroup> rgList = dbCache.getResearchGroups(ui, false);
			List<Experiment> expList = dbCache.getExperiments(ui, false);
			Map<BigDecimal, List<Researchgroup>> map = new HashMap<BigDecimal, List<Researchgroup>>(
					11);
			for (Researchgroup rg : rgList) {
				List<Researchgroup> expRgList = map.get(rg
						.getNcExperimentUniqueid());
				if (expRgList == null) {
					expRgList = new ArrayList<Researchgroup>(3);
					map.put(rg.getNcExperimentUniqueid(), expRgList);
				}
				expRgList.add(rg);
			}

			List<Protocol> protocols = dbCache.getProtocols(ui, true);
			List<Collectionequipment> ceList = dbCache.getCollectionEquipments(
					ui, false);

			List<ProtocolInfo> piList = new ArrayList<ProtocolInfo>(
					protocols.size());
			List<ColEquipInfo> ceiList = new ArrayList<ColEquipInfo>(
					ceList.size());
			for (Protocol p : protocols) {
				ProtocolInfo pi = new ProtocolInfo(p.getProtocolversion()
						.intValue(), p.getProtocolid(), p.getName(), null);
				piList.add(pi);
			}
			for (Collectionequipment ce : ceList) {
				ColEquipInfo cei = new ColEquipInfo(
						ce.getUniqueid().intValue(), ce.getMake(),
						ce.getModel());
				ceiList.add(cei);
			}

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			IExperimentManagement iem = ServiceFactory
					.getExperimentManagement(dbID);

			List<Humansubject> allSubjects = isvm.getAllSubjects(ui);
			Map<String, Humansubject> hsMap = new HashMap<String, Humansubject>();
			for (Humansubject hs : allSubjects) {
				hsMap.put(hs.getSubjectid(), hs);
			}
			allSubjects = null;

			List<ExperimentInfo> eiList = new ArrayList<ExperimentInfo>(3);
			for (Experiment exp : expList) {
				System.out.println(ui.getName() + " isAuthorized for exp:"
						+ exp.getName());
				if (authService.isAuthorized(ui, dbID, PrivilegeLabel.READ, exp
						.getUniqueid().intValue())) {
					ExperimentInfo ei = new ExperimentInfo(exp.getName(), exp
							.getUniqueid().intValue());
					List<Researchgroup> expRgList = map.get(exp.getUniqueid());
					if (expRgList != null) {
						for (Researchgroup rg : expRgList) {
							RGInfo rgi = new RGInfo(rg.getName(),
									rg.getDescription());
							ei.addRGInfo(rgi);
						}
					} else {
						// skip experiment with no research groups
						System.out
								.println("skipping experiment with no research groups: "
										+ ei.getName());
						continue;
					}
					List<Subjexperiment> enrolledSubjects = iem
							.getEnrolledSubjects(ui, ei.getExpId());
					expRgList = map.get(exp.getUniqueid());
					Map<BigDecimal, Researchgroup> rgMap = toMap(expRgList);
					for (Subjexperiment se : enrolledSubjects) {
						Researchgroup rg = rgMap.get(se
								.getNcResearchgroupUniqueid());
						Assertion.assertNotNull(rg);
						Humansubject hs = hsMap.get(se.getSubjectid());
						String gender = hs.getGender();
						EnrolledSubject es = new EnrolledSubject(
								se.getSubjectid(), rg.getName(), gender);
						ei.addEnrolledSubject(es);
					}

					eiList.add(ei);
				}
			}

			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("experiments", jsArr);
			for (ExperimentInfo ei : eiList) {
				jsArr.put(ei.toJSON());
			}
			jsArr = new JSONArray();
			js.put("protocolList", jsArr);
			for (ProtocolInfo pi : piList) {
				jsArr.put(pi.toJSON());
			}
			jsArr = new JSONArray();
			js.put("ceiList", jsArr);
			for (ColEquipInfo cei : ceiList) {
				jsArr.put(cei.toJSON());
			}

			prepJSONResponse(response, js);

		} catch (Exception x) {
			log.error("ASLUploadCommunicationAction", x);
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("experiments", jsArr);
			prepJSONResponse(response, js);
		}
		return null;
	}

	public static Map<BigDecimal, Researchgroup> toMap(
			List<Researchgroup> rgList) {
		Map<BigDecimal, Researchgroup> map = new HashMap<BigDecimal, Researchgroup>(
				11);
		for (Researchgroup rg : rgList) {
			map.put(rg.getUniqueid(), rg);
		}
		return map;
	}

	protected void prepJSONResponse(HttpServletResponse response, JSONObject js)
			throws IOException {
		response.setContentType("application/json");
		String jsonStr = js.toString();
		log.info("jsonStr:" + jsonStr);
		response.getOutputStream().println(jsonStr);
	}

	protected String getDBID() throws Exception {
		IAppConfigService cs = AppConfigService.getInstance();
		String dbID = cs.getParamValue("fbirn.dbid");

		if (dbID == null || dbID.trim().length() == 0) {
			throw new Exception(
					"Cannot detect data source! Possible misconfiguration!");
		}
		return dbID;
	}
}
